<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelSearch StructType
 * @subpackage Structs
 */
class HotelSearch extends AbstractStructBase
{
    /**
     * The HOTEL_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $HOTEL_OBJID;
    /**
     * The DUMMY_INTERNAL
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9])*
     * @var string
     */
    public $DUMMY_INTERNAL;
    /**
     * Constructor method for HotelSearch
     * @uses HotelSearch::setHOTEL_OBJID()
     * @uses HotelSearch::setDUMMY_INTERNAL()
     * @param string $hOTEL_OBJID
     * @param string $dUMMY_INTERNAL
     */
    public function __construct($hOTEL_OBJID = null, $dUMMY_INTERNAL = null)
    {
        $this
            ->setHOTEL_OBJID($hOTEL_OBJID)
            ->setDUMMY_INTERNAL($dUMMY_INTERNAL);
    }
    /**
     * Get HOTEL_OBJID value
     * @return string
     */
    public function getHOTEL_OBJID()
    {
        return $this->{'HOTEL-OBJID'};
    }
    /**
     * Set HOTEL_OBJID value
     * @param string $hOTEL_OBJID
     * @return \StructType\HotelSearch
     */
    public function setHOTEL_OBJID($hOTEL_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($hOTEL_OBJID) && !is_string($hOTEL_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hOTEL_OBJID, true), gettype($hOTEL_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($hOTEL_OBJID) && !preg_match('/([0-9])*/', $hOTEL_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($hOTEL_OBJID, true)), __LINE__);
        }
        $this->HOTEL_OBJID = $this->{'HOTEL-OBJID'} = $hOTEL_OBJID;
        return $this;
    }
    /**
     * Get DUMMY_INTERNAL value
     * @return string|null
     */
    public function getDUMMY_INTERNAL()
    {
        return $this->DUMMY_INTERNAL;
    }
    /**
     * Set DUMMY_INTERNAL value
     * @param string $dUMMY_INTERNAL
     * @return \StructType\HotelSearch
     */
    public function setDUMMY_INTERNAL($dUMMY_INTERNAL = null)
    {
        // validation for constraint: string
        if (!is_null($dUMMY_INTERNAL) && !is_string($dUMMY_INTERNAL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dUMMY_INTERNAL, true), gettype($dUMMY_INTERNAL)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($dUMMY_INTERNAL) && !preg_match('/([0-9])*/', $dUMMY_INTERNAL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($dUMMY_INTERNAL, true)), __LINE__);
        }
        $this->DUMMY_INTERNAL = $dUMMY_INTERNAL;
        return $this;
    }
}
