<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HOLDER StructType
 * @subpackage Structs
 */
class HOLDER extends AbstractStructBase
{
    /**
     * The HOLDER_CENTRALID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $HOLDER_CENTRALID;
    /**
     * The lastnamefirstname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $lastnamefirstname;
    /**
     * The HOLDER_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9])*
     * @var string
     */
    public $HOLDER_OBJID;
    /**
     * Constructor method for HOLDER
     * @uses HOLDER::setHOLDER_CENTRALID()
     * @uses HOLDER::setLastnamefirstname()
     * @uses HOLDER::setHOLDER_OBJID()
     * @param string $hOLDER_CENTRALID
     * @param string $lastnamefirstname
     * @param string $hOLDER_OBJID
     */
    public function __construct($hOLDER_CENTRALID = null, $lastnamefirstname = null, $hOLDER_OBJID = null)
    {
        $this
            ->setHOLDER_CENTRALID($hOLDER_CENTRALID)
            ->setLastnamefirstname($lastnamefirstname)
            ->setHOLDER_OBJID($hOLDER_OBJID);
    }
    /**
     * Get HOLDER_CENTRALID value
     * @return string
     */
    public function getHOLDER_CENTRALID()
    {
        return $this->{'HOLDER-CENTRALID'};
    }
    /**
     * Set HOLDER_CENTRALID value
     * @param string $hOLDER_CENTRALID
     * @return \StructType\HOLDER
     */
    public function setHOLDER_CENTRALID($hOLDER_CENTRALID = null)
    {
        // validation for constraint: string
        if (!is_null($hOLDER_CENTRALID) && !is_string($hOLDER_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hOLDER_CENTRALID, true), gettype($hOLDER_CENTRALID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($hOLDER_CENTRALID) && !preg_match('/([0-9])*/', $hOLDER_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($hOLDER_CENTRALID, true)), __LINE__);
        }
        $this->HOLDER_CENTRALID = $this->{'HOLDER-CENTRALID'} = $hOLDER_CENTRALID;
        return $this;
    }
    /**
     * Get lastnamefirstname value
     * @return string
     */
    public function getLastnamefirstname()
    {
        return $this->lastnamefirstname;
    }
    /**
     * Set lastnamefirstname value
     * @param string $lastnamefirstname
     * @return \StructType\HOLDER
     */
    public function setLastnamefirstname($lastnamefirstname = null)
    {
        // validation for constraint: string
        if (!is_null($lastnamefirstname) && !is_string($lastnamefirstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastnamefirstname, true), gettype($lastnamefirstname)), __LINE__);
        }
        $this->lastnamefirstname = $lastnamefirstname;
        return $this;
    }
    /**
     * Get HOLDER_OBJID value
     * @return string|null
     */
    public function getHOLDER_OBJID()
    {
        return $this->{'HOLDER-OBJID'};
    }
    /**
     * Set HOLDER_OBJID value
     * @param string $hOLDER_OBJID
     * @return \StructType\HOLDER
     */
    public function setHOLDER_OBJID($hOLDER_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($hOLDER_OBJID) && !is_string($hOLDER_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hOLDER_OBJID, true), gettype($hOLDER_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($hOLDER_OBJID) && !preg_match('/([0-9])*/', $hOLDER_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($hOLDER_OBJID, true)), __LINE__);
        }
        $this->HOLDER_OBJID = $this->{'HOLDER-OBJID'} = $hOLDER_OBJID;
        return $this;
    }
}
