<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuestInfo StructType
 * @subpackage Structs
 */
class GuestInfo extends AbstractStructBase
{
    /**
     * The Person
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Person[]
     */
    public $Person;
    /**
     * Constructor method for GuestInfo
     * @uses GuestInfo::setPerson()
     * @param \StructType\Person[] $person
     */
    public function __construct(array $person = array())
    {
        $this
            ->setPerson($person);
    }
    /**
     * Get Person value
     * @return \StructType\Person[]|null
     */
    public function getPerson()
    {
        return $this->Person;
    }
    /**
     * This method is responsible for validating the values passed to the setPerson method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPerson method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePersonForArrayConstraintsFromSetPerson(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guestInfoPersonItem) {
            // validation for constraint: itemType
            if (!$guestInfoPersonItem instanceof \StructType\Person) {
                $invalidValues[] = is_object($guestInfoPersonItem) ? get_class($guestInfoPersonItem) : sprintf('%s(%s)', gettype($guestInfoPersonItem), var_export($guestInfoPersonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Person property can only contain items of type \StructType\Person, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Person value
     * @throws \InvalidArgumentException
     * @param \StructType\Person[] $person
     * @return \StructType\GuestInfo
     */
    public function setPerson(array $person = array())
    {
        // validation for constraint: array
        if ('' !== ($personArrayErrorMessage = self::validatePersonForArrayConstraintsFromSetPerson($person))) {
            throw new \InvalidArgumentException($personArrayErrorMessage, __LINE__);
        }
        $this->Person = $person;
        return $this;
    }
    /**
     * Add item to Person value
     * @throws \InvalidArgumentException
     * @param \StructType\Person $item
     * @return \StructType\GuestInfo
     */
    public function addToPerson(\StructType\Person $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Person) {
            throw new \InvalidArgumentException(sprintf('The Person property can only contain items of type \StructType\Person, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Person[] = $item;
        return $this;
    }
}
