<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GiftvoucherHolder StructType
 * @subpackage Structs
 */
class GiftvoucherHolder extends AbstractStructBase
{
    /**
     * The objid
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $objid;
    /**
     * The lastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $lastName;
    /**
     * The firstName
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $firstName;
    /**
     * The matchcode
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $matchcode;
    /**
     * The guestHotel
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $guestHotel;
    /**
     * The guestNo
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $guestNo;
    /**
     * Constructor method for GiftvoucherHolder
     * @uses GiftvoucherHolder::setObjid()
     * @uses GiftvoucherHolder::setLastName()
     * @uses GiftvoucherHolder::setFirstName()
     * @uses GiftvoucherHolder::setMatchcode()
     * @uses GiftvoucherHolder::setGuestHotel()
     * @uses GiftvoucherHolder::setGuestNo()
     * @param string $objid
     * @param string $lastName
     * @param string $firstName
     * @param string $matchcode
     * @param string $guestHotel
     * @param string $guestNo
     */
    public function __construct($objid = null, $lastName = null, $firstName = null, $matchcode = null, $guestHotel = null, $guestNo = null)
    {
        $this
            ->setObjid($objid)
            ->setLastName($lastName)
            ->setFirstName($firstName)
            ->setMatchcode($matchcode)
            ->setGuestHotel($guestHotel)
            ->setGuestNo($guestNo);
    }
    /**
     * Get objid value
     * @return string
     */
    public function getObjid()
    {
        return $this->objid;
    }
    /**
     * Set objid value
     * @param string $objid
     * @return \StructType\GiftvoucherHolder
     */
    public function setObjid($objid = null)
    {
        // validation for constraint: string
        if (!is_null($objid) && !is_string($objid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objid, true), gettype($objid)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($objid) && !preg_match('/([0-9])*/', $objid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($objid, true)), __LINE__);
        }
        $this->objid = $objid;
        return $this;
    }
    /**
     * Get lastName value
     * @return string
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \StructType\GiftvoucherHolder
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get firstName value
     * @return string
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \StructType\GiftvoucherHolder
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($firstName) && mb_strlen($firstName) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($firstName)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($firstName) && mb_strlen($firstName) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get matchcode value
     * @return string
     */
    public function getMatchcode()
    {
        return $this->matchcode;
    }
    /**
     * Set matchcode value
     * @param string $matchcode
     * @return \StructType\GiftvoucherHolder
     */
    public function setMatchcode($matchcode = null)
    {
        // validation for constraint: string
        if (!is_null($matchcode) && !is_string($matchcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matchcode, true), gettype($matchcode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($matchcode) && mb_strlen($matchcode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($matchcode)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($matchcode) && mb_strlen($matchcode) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($matchcode)), __LINE__);
        }
        $this->matchcode = $matchcode;
        return $this;
    }
    /**
     * Get guestHotel value
     * @return string
     */
    public function getGuestHotel()
    {
        return $this->guestHotel;
    }
    /**
     * Set guestHotel value
     * @param string $guestHotel
     * @return \StructType\GiftvoucherHolder
     */
    public function setGuestHotel($guestHotel = null)
    {
        // validation for constraint: string
        if (!is_null($guestHotel) && !is_string($guestHotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guestHotel, true), gettype($guestHotel)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($guestHotel) && !preg_match('/([-+]){0,1}([0-9])*/', $guestHotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($guestHotel, true)), __LINE__);
        }
        $this->guestHotel = $guestHotel;
        return $this;
    }
    /**
     * Get guestNo value
     * @return string
     */
    public function getGuestNo()
    {
        return $this->guestNo;
    }
    /**
     * Set guestNo value
     * @param string $guestNo
     * @return \StructType\GiftvoucherHolder
     */
    public function setGuestNo($guestNo = null)
    {
        // validation for constraint: string
        if (!is_null($guestNo) && !is_string($guestNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guestNo, true), gettype($guestNo)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($guestNo) && !preg_match('/([-+]){0,1}([0-9])*/', $guestNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($guestNo, true)), __LINE__);
        }
        $this->guestNo = $guestNo;
        return $this;
    }
}
