<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GiftVoucherSell StructType
 * @subpackage Structs
 */
class GiftVoucherSell extends AbstractStructBase
{
    /**
     * The guestObjID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $guestObjID;
    /**
     * The serviceCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $serviceCode;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $amount;
    /**
     * The typeofpayment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $typeofpayment;
    /**
     * The externalreference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $externalreference;
    /**
     * The expirydate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $expirydate;
    /**
     * Constructor method for GiftVoucherSell
     * @uses GiftVoucherSell::setGuestObjID()
     * @uses GiftVoucherSell::setServiceCode()
     * @uses GiftVoucherSell::setAmount()
     * @uses GiftVoucherSell::setTypeofpayment()
     * @uses GiftVoucherSell::setExternalreference()
     * @uses GiftVoucherSell::setExpirydate()
     * @param string $guestObjID
     * @param string $serviceCode
     * @param string $amount
     * @param string $typeofpayment
     * @param string $externalreference
     * @param string $expirydate
     */
    public function __construct($guestObjID = null, $serviceCode = null, $amount = null, $typeofpayment = null, $externalreference = null, $expirydate = null)
    {
        $this
            ->setGuestObjID($guestObjID)
            ->setServiceCode($serviceCode)
            ->setAmount($amount)
            ->setTypeofpayment($typeofpayment)
            ->setExternalreference($externalreference)
            ->setExpirydate($expirydate);
    }
    /**
     * Get guestObjID value
     * @return string
     */
    public function getGuestObjID()
    {
        return $this->guestObjID;
    }
    /**
     * Set guestObjID value
     * @param string $guestObjID
     * @return \StructType\GiftVoucherSell
     */
    public function setGuestObjID($guestObjID = null)
    {
        // validation for constraint: string
        if (!is_null($guestObjID) && !is_string($guestObjID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guestObjID, true), gettype($guestObjID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($guestObjID) && !preg_match('/([0-9])*/', $guestObjID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($guestObjID, true)), __LINE__);
        }
        $this->guestObjID = $guestObjID;
        return $this;
    }
    /**
     * Get serviceCode value
     * @return string
     */
    public function getServiceCode()
    {
        return $this->serviceCode;
    }
    /**
     * Set serviceCode value
     * @param string $serviceCode
     * @return \StructType\GiftVoucherSell
     */
    public function setServiceCode($serviceCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceCode) && !is_string($serviceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceCode, true), gettype($serviceCode)), __LINE__);
        }
        $this->serviceCode = $serviceCode;
        return $this;
    }
    /**
     * Get amount value
     * @return string
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param string $amount
     * @return \StructType\GiftVoucherSell
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($amount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($amount, true)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get typeofpayment value
     * @return string
     */
    public function getTypeofpayment()
    {
        return $this->typeofpayment;
    }
    /**
     * Set typeofpayment value
     * @param string $typeofpayment
     * @return \StructType\GiftVoucherSell
     */
    public function setTypeofpayment($typeofpayment = null)
    {
        // validation for constraint: string
        if (!is_null($typeofpayment) && !is_string($typeofpayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeofpayment, true), gettype($typeofpayment)), __LINE__);
        }
        $this->typeofpayment = $typeofpayment;
        return $this;
    }
    /**
     * Get externalreference value
     * @return string|null
     */
    public function getExternalreference()
    {
        return $this->externalreference;
    }
    /**
     * Set externalreference value
     * @param string $externalreference
     * @return \StructType\GiftVoucherSell
     */
    public function setExternalreference($externalreference = null)
    {
        // validation for constraint: string
        if (!is_null($externalreference) && !is_string($externalreference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalreference, true), gettype($externalreference)), __LINE__);
        }
        $this->externalreference = $externalreference;
        return $this;
    }
    /**
     * Get expirydate value
     * @return string|null
     */
    public function getExpirydate()
    {
        return $this->expirydate;
    }
    /**
     * Set expirydate value
     * @param string $expirydate
     * @return \StructType\GiftVoucherSell
     */
    public function setExpirydate($expirydate = null)
    {
        // validation for constraint: string
        if (!is_null($expirydate) && !is_string($expirydate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirydate, true), gettype($expirydate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($expirydate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $expirydate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($expirydate, true)), __LINE__);
        }
        $this->expirydate = $expirydate;
        return $this;
    }
}
