<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GiftVoucherRedeem StructType
 * @subpackage Structs
 */
class GiftVoucherRedeem extends AbstractStructBase
{
    /**
     * The accountObjID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $accountObjID;
    /**
     * The accounttype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $accounttype;
    /**
     * The giftvoucherno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $giftvoucherno;
    /**
     * The hotelsell
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $hotelsell;
    /**
     * Constructor method for GiftVoucherRedeem
     * @uses GiftVoucherRedeem::setAccountObjID()
     * @uses GiftVoucherRedeem::setAccounttype()
     * @uses GiftVoucherRedeem::setGiftvoucherno()
     * @uses GiftVoucherRedeem::setHotelsell()
     * @param string $accountObjID
     * @param string $accounttype
     * @param string $giftvoucherno
     * @param string $hotelsell
     */
    public function __construct($accountObjID = null, $accounttype = null, $giftvoucherno = null, $hotelsell = null)
    {
        $this
            ->setAccountObjID($accountObjID)
            ->setAccounttype($accounttype)
            ->setGiftvoucherno($giftvoucherno)
            ->setHotelsell($hotelsell);
    }
    /**
     * Get accountObjID value
     * @return string
     */
    public function getAccountObjID()
    {
        return $this->accountObjID;
    }
    /**
     * Set accountObjID value
     * @param string $accountObjID
     * @return \StructType\GiftVoucherRedeem
     */
    public function setAccountObjID($accountObjID = null)
    {
        // validation for constraint: string
        if (!is_null($accountObjID) && !is_string($accountObjID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountObjID, true), gettype($accountObjID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($accountObjID) && !preg_match('/([0-9])*/', $accountObjID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($accountObjID, true)), __LINE__);
        }
        $this->accountObjID = $accountObjID;
        return $this;
    }
    /**
     * Get accounttype value
     * @return string
     */
    public function getAccounttype()
    {
        return $this->accounttype;
    }
    /**
     * Set accounttype value
     * @param string $accounttype
     * @return \StructType\GiftVoucherRedeem
     */
    public function setAccounttype($accounttype = null)
    {
        // validation for constraint: string
        if (!is_null($accounttype) && !is_string($accounttype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accounttype, true), gettype($accounttype)), __LINE__);
        }
        $this->accounttype = $accounttype;
        return $this;
    }
    /**
     * Get giftvoucherno value
     * @return string
     */
    public function getGiftvoucherno()
    {
        return $this->giftvoucherno;
    }
    /**
     * Set giftvoucherno value
     * @param string $giftvoucherno
     * @return \StructType\GiftVoucherRedeem
     */
    public function setGiftvoucherno($giftvoucherno = null)
    {
        // validation for constraint: string
        if (!is_null($giftvoucherno) && !is_string($giftvoucherno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftvoucherno, true), gettype($giftvoucherno)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($giftvoucherno) && !preg_match('/([-+]){0,1}([0-9])*/', $giftvoucherno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($giftvoucherno, true)), __LINE__);
        }
        $this->giftvoucherno = $giftvoucherno;
        return $this;
    }
    /**
     * Get hotelsell value
     * @return string|null
     */
    public function getHotelsell()
    {
        return $this->hotelsell;
    }
    /**
     * Set hotelsell value
     * @param string $hotelsell
     * @return \StructType\GiftVoucherRedeem
     */
    public function setHotelsell($hotelsell = null)
    {
        // validation for constraint: string
        if (!is_null($hotelsell) && !is_string($hotelsell)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelsell, true), gettype($hotelsell)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($hotelsell) && !preg_match('/([-+]){0,1}([0-9])*/', $hotelsell)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($hotelsell, true)), __LINE__);
        }
        $this->hotelsell = $hotelsell;
        return $this;
    }
}
