<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPackageMappingResponse StructType
 * @subpackage Structs
 */
class GetPackageMappingResponse extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The PackageSearchEntry
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PackageSearchEntry[]
     */
    public $PackageSearchEntry;
    /**
     * Constructor method for GetPackageMappingResponse
     * @uses GetPackageMappingResponse::setResult()
     * @uses GetPackageMappingResponse::setTransactionID()
     * @uses GetPackageMappingResponse::setPackageSearchEntry()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\PackageSearchEntry[] $packageSearchEntry
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $packageSearchEntry = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setPackageSearchEntry($packageSearchEntry);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\GetPackageMappingResponse
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\GetPackageMappingResponse
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get PackageSearchEntry value
     * @return \StructType\PackageSearchEntry[]|null
     */
    public function getPackageSearchEntry()
    {
        return $this->PackageSearchEntry;
    }
    /**
     * This method is responsible for validating the values passed to the setPackageSearchEntry method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackageSearchEntry method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackageSearchEntryForArrayConstraintsFromSetPackageSearchEntry(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getPackageMappingResponsePackageSearchEntryItem) {
            // validation for constraint: itemType
            if (!$getPackageMappingResponsePackageSearchEntryItem instanceof \StructType\PackageSearchEntry) {
                $invalidValues[] = is_object($getPackageMappingResponsePackageSearchEntryItem) ? get_class($getPackageMappingResponsePackageSearchEntryItem) : sprintf('%s(%s)', gettype($getPackageMappingResponsePackageSearchEntryItem), var_export($getPackageMappingResponsePackageSearchEntryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PackageSearchEntry property can only contain items of type \StructType\PackageSearchEntry, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PackageSearchEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\PackageSearchEntry[] $packageSearchEntry
     * @return \StructType\GetPackageMappingResponse
     */
    public function setPackageSearchEntry(array $packageSearchEntry = array())
    {
        // validation for constraint: array
        if ('' !== ($packageSearchEntryArrayErrorMessage = self::validatePackageSearchEntryForArrayConstraintsFromSetPackageSearchEntry($packageSearchEntry))) {
            throw new \InvalidArgumentException($packageSearchEntryArrayErrorMessage, __LINE__);
        }
        $this->PackageSearchEntry = $packageSearchEntry;
        return $this;
    }
    /**
     * Add item to PackageSearchEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\PackageSearchEntry $item
     * @return \StructType\GetPackageMappingResponse
     */
    public function addToPackageSearchEntry(\StructType\PackageSearchEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PackageSearchEntry) {
            throw new \InvalidArgumentException(sprintf('The PackageSearchEntry property can only contain items of type \StructType\PackageSearchEntry, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PackageSearchEntry[] = $item;
        return $this;
    }
}
