<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCategoryMappingResponse StructType
 * @subpackage Structs
 */
class GetCategoryMappingResponse extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The CategorySearchEntry
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CategorySearchEntry[]
     */
    public $CategorySearchEntry;
    /**
     * Constructor method for GetCategoryMappingResponse
     * @uses GetCategoryMappingResponse::setResult()
     * @uses GetCategoryMappingResponse::setTransactionID()
     * @uses GetCategoryMappingResponse::setCategorySearchEntry()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\CategorySearchEntry[] $categorySearchEntry
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $categorySearchEntry = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setCategorySearchEntry($categorySearchEntry);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\GetCategoryMappingResponse
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\GetCategoryMappingResponse
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get CategorySearchEntry value
     * @return \StructType\CategorySearchEntry[]|null
     */
    public function getCategorySearchEntry()
    {
        return $this->CategorySearchEntry;
    }
    /**
     * This method is responsible for validating the values passed to the setCategorySearchEntry method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCategorySearchEntry method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCategorySearchEntryForArrayConstraintsFromSetCategorySearchEntry(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getCategoryMappingResponseCategorySearchEntryItem) {
            // validation for constraint: itemType
            if (!$getCategoryMappingResponseCategorySearchEntryItem instanceof \StructType\CategorySearchEntry) {
                $invalidValues[] = is_object($getCategoryMappingResponseCategorySearchEntryItem) ? get_class($getCategoryMappingResponseCategorySearchEntryItem) : sprintf('%s(%s)', gettype($getCategoryMappingResponseCategorySearchEntryItem), var_export($getCategoryMappingResponseCategorySearchEntryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CategorySearchEntry property can only contain items of type \StructType\CategorySearchEntry, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CategorySearchEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\CategorySearchEntry[] $categorySearchEntry
     * @return \StructType\GetCategoryMappingResponse
     */
    public function setCategorySearchEntry(array $categorySearchEntry = array())
    {
        // validation for constraint: array
        if ('' !== ($categorySearchEntryArrayErrorMessage = self::validateCategorySearchEntryForArrayConstraintsFromSetCategorySearchEntry($categorySearchEntry))) {
            throw new \InvalidArgumentException($categorySearchEntryArrayErrorMessage, __LINE__);
        }
        $this->CategorySearchEntry = $categorySearchEntry;
        return $this;
    }
    /**
     * Add item to CategorySearchEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\CategorySearchEntry $item
     * @return \StructType\GetCategoryMappingResponse
     */
    public function addToCategorySearchEntry(\StructType\CategorySearchEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CategorySearchEntry) {
            throw new \InvalidArgumentException(sprintf('The CategorySearchEntry property can only contain items of type \StructType\CategorySearchEntry, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CategorySearchEntry[] = $item;
        return $this;
    }
}
