<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCategoryMappingRequest StructType
 * @subpackage Structs
 */
class GetCategoryMappingRequest extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The CategorySearch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\CategorySearch
     */
    public $CategorySearch;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for GetCategoryMappingRequest
     * @uses GetCategoryMappingRequest::setAuthentication()
     * @uses GetCategoryMappingRequest::setCategorySearch()
     * @uses GetCategoryMappingRequest::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\CategorySearch $categorySearch
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\CategorySearch $categorySearch = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setCategorySearch($categorySearch)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\GetCategoryMappingRequest
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get CategorySearch value
     * @return \StructType\CategorySearch
     */
    public function getCategorySearch()
    {
        return $this->CategorySearch;
    }
    /**
     * Set CategorySearch value
     * @param \StructType\CategorySearch $categorySearch
     * @return \StructType\GetCategoryMappingRequest
     */
    public function setCategorySearch(\StructType\CategorySearch $categorySearch = null)
    {
        $this->CategorySearch = $categorySearch;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\GetCategoryMappingRequest
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
