<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GUEST-IDENTIFICATION StructType
 * @subpackage Structs
 */
class GUEST_IDENTIFICATION extends AbstractStructBase
{
    /**
     * The GUEST_IDENTIFICATION_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $GUEST_IDENTIFICATION_OBJID;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $type;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $number;
    /**
     * Constructor method for GUEST-IDENTIFICATION
     * @uses GUEST_IDENTIFICATION::setGUEST_IDENTIFICATION_OBJID()
     * @uses GUEST_IDENTIFICATION::setType()
     * @uses GUEST_IDENTIFICATION::setNumber()
     * @param string $gUEST_IDENTIFICATION_OBJID
     * @param string $type
     * @param string $number
     */
    public function __construct($gUEST_IDENTIFICATION_OBJID = null, $type = null, $number = null)
    {
        $this
            ->setGUEST_IDENTIFICATION_OBJID($gUEST_IDENTIFICATION_OBJID)
            ->setType($type)
            ->setNumber($number);
    }
    /**
     * Get GUEST_IDENTIFICATION_OBJID value
     * @return string
     */
    public function getGUEST_IDENTIFICATION_OBJID()
    {
        return $this->{'GUEST-IDENTIFICATION-OBJID'};
    }
    /**
     * Set GUEST_IDENTIFICATION_OBJID value
     * @param string $gUEST_IDENTIFICATION_OBJID
     * @return \StructType\GUEST_IDENTIFICATION
     */
    public function setGUEST_IDENTIFICATION_OBJID($gUEST_IDENTIFICATION_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($gUEST_IDENTIFICATION_OBJID) && !is_string($gUEST_IDENTIFICATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gUEST_IDENTIFICATION_OBJID, true), gettype($gUEST_IDENTIFICATION_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($gUEST_IDENTIFICATION_OBJID) && !preg_match('/([0-9])*/', $gUEST_IDENTIFICATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($gUEST_IDENTIFICATION_OBJID, true)), __LINE__);
        }
        $this->GUEST_IDENTIFICATION_OBJID = $this->{'GUEST-IDENTIFICATION-OBJID'} = $gUEST_IDENTIFICATION_OBJID;
        return $this;
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\GUEST_IDENTIFICATION
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($type) && mb_strlen($type) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($type)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($type) && mb_strlen($type) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get number value
     * @return string
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\GUEST_IDENTIFICATION
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
}
