<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FollowUps StructType
 * @subpackage Structs
 */
class FollowUps extends AbstractStructBase
{
    /**
     * The FollowUp
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FollowUp[]
     */
    public $FollowUp;
    /**
     * Constructor method for FollowUps
     * @uses FollowUps::setFollowUp()
     * @param \StructType\FollowUp[] $followUp
     */
    public function __construct(array $followUp = array())
    {
        $this
            ->setFollowUp($followUp);
    }
    /**
     * Get FollowUp value
     * @return \StructType\FollowUp[]|null
     */
    public function getFollowUp()
    {
        return $this->FollowUp;
    }
    /**
     * This method is responsible for validating the values passed to the setFollowUp method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFollowUp method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFollowUpForArrayConstraintsFromSetFollowUp(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $followUpsFollowUpItem) {
            // validation for constraint: itemType
            if (!$followUpsFollowUpItem instanceof \StructType\FollowUp) {
                $invalidValues[] = is_object($followUpsFollowUpItem) ? get_class($followUpsFollowUpItem) : sprintf('%s(%s)', gettype($followUpsFollowUpItem), var_export($followUpsFollowUpItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FollowUp property can only contain items of type \StructType\FollowUp, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FollowUp value
     * @throws \InvalidArgumentException
     * @param \StructType\FollowUp[] $followUp
     * @return \StructType\FollowUps
     */
    public function setFollowUp(array $followUp = array())
    {
        // validation for constraint: array
        if ('' !== ($followUpArrayErrorMessage = self::validateFollowUpForArrayConstraintsFromSetFollowUp($followUp))) {
            throw new \InvalidArgumentException($followUpArrayErrorMessage, __LINE__);
        }
        $this->FollowUp = $followUp;
        return $this;
    }
    /**
     * Add item to FollowUp value
     * @throws \InvalidArgumentException
     * @param \StructType\FollowUp $item
     * @return \StructType\FollowUps
     */
    public function addToFollowUp(\StructType\FollowUp $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FollowUp) {
            throw new \InvalidArgumentException(sprintf('The FollowUp property can only contain items of type \StructType\FollowUp, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FollowUp[] = $item;
        return $this;
    }
}
