<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Feedback StructType
 * @subpackage Structs
 */
class Feedback extends AbstractStructBase
{
    /**
     * The rating
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $rating;
    /**
     * The FeedbackEntry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\FeedbackEntry
     */
    public $FeedbackEntry;
    /**
     * The maxrating
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $maxrating;
    /**
     * The feedbackdate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $feedbackdate;
    /**
     * The feedbacktime
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $feedbacktime;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $location;
    /**
     * The sleepquality
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $sleepquality;
    /**
     * The feedbackservice
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $feedbackservice;
    /**
     * The cleanliness
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $cleanliness;
    /**
     * The rooms
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $rooms;
    /**
     * The priceperformance
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $priceperformance;
    /**
     * The text
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $text;
    /**
     * Constructor method for Feedback
     * @uses Feedback::setRating()
     * @uses Feedback::setFeedbackEntry()
     * @uses Feedback::setMaxrating()
     * @uses Feedback::setFeedbackdate()
     * @uses Feedback::setFeedbacktime()
     * @uses Feedback::setLocation()
     * @uses Feedback::setSleepquality()
     * @uses Feedback::setFeedbackservice()
     * @uses Feedback::setCleanliness()
     * @uses Feedback::setRooms()
     * @uses Feedback::setPriceperformance()
     * @uses Feedback::setText()
     * @param string $rating
     * @param \StructType\FeedbackEntry $feedbackEntry
     * @param string $maxrating
     * @param string $feedbackdate
     * @param string $feedbacktime
     * @param string $location
     * @param string $sleepquality
     * @param string $feedbackservice
     * @param string $cleanliness
     * @param string $rooms
     * @param string $priceperformance
     * @param string $text
     */
    public function __construct($rating = null, \StructType\FeedbackEntry $feedbackEntry = null, $maxrating = null, $feedbackdate = null, $feedbacktime = null, $location = null, $sleepquality = null, $feedbackservice = null, $cleanliness = null, $rooms = null, $priceperformance = null, $text = null)
    {
        $this
            ->setRating($rating)
            ->setFeedbackEntry($feedbackEntry)
            ->setMaxrating($maxrating)
            ->setFeedbackdate($feedbackdate)
            ->setFeedbacktime($feedbacktime)
            ->setLocation($location)
            ->setSleepquality($sleepquality)
            ->setFeedbackservice($feedbackservice)
            ->setCleanliness($cleanliness)
            ->setRooms($rooms)
            ->setPriceperformance($priceperformance)
            ->setText($text);
    }
    /**
     * Get rating value
     * @return string
     */
    public function getRating()
    {
        return $this->rating;
    }
    /**
     * Set rating value
     * @param string $rating
     * @return \StructType\Feedback
     */
    public function setRating($rating = null)
    {
        // validation for constraint: string
        if (!is_null($rating) && !is_string($rating)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rating, true), gettype($rating)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($rating) && !preg_match('/([-+]){0,1}([0-9])*/', $rating)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($rating, true)), __LINE__);
        }
        $this->rating = $rating;
        return $this;
    }
    /**
     * Get FeedbackEntry value
     * @return \StructType\FeedbackEntry
     */
    public function getFeedbackEntry()
    {
        return $this->FeedbackEntry;
    }
    /**
     * Set FeedbackEntry value
     * @param \StructType\FeedbackEntry $feedbackEntry
     * @return \StructType\Feedback
     */
    public function setFeedbackEntry(\StructType\FeedbackEntry $feedbackEntry = null)
    {
        $this->FeedbackEntry = $feedbackEntry;
        return $this;
    }
    /**
     * Get maxrating value
     * @return string
     */
    public function getMaxrating()
    {
        return $this->maxrating;
    }
    /**
     * Set maxrating value
     * @param string $maxrating
     * @return \StructType\Feedback
     */
    public function setMaxrating($maxrating = null)
    {
        // validation for constraint: string
        if (!is_null($maxrating) && !is_string($maxrating)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxrating, true), gettype($maxrating)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($maxrating) && !preg_match('/([-+]){0,1}([0-9])*/', $maxrating)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($maxrating, true)), __LINE__);
        }
        $this->maxrating = $maxrating;
        return $this;
    }
    /**
     * Get feedbackdate value
     * @return string
     */
    public function getFeedbackdate()
    {
        return $this->feedbackdate;
    }
    /**
     * Set feedbackdate value
     * @param string $feedbackdate
     * @return \StructType\Feedback
     */
    public function setFeedbackdate($feedbackdate = null)
    {
        // validation for constraint: string
        if (!is_null($feedbackdate) && !is_string($feedbackdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feedbackdate, true), gettype($feedbackdate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($feedbackdate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $feedbackdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($feedbackdate, true)), __LINE__);
        }
        $this->feedbackdate = $feedbackdate;
        return $this;
    }
    /**
     * Get feedbacktime value
     * @return string
     */
    public function getFeedbacktime()
    {
        return $this->feedbacktime;
    }
    /**
     * Set feedbacktime value
     * @param string $feedbacktime
     * @return \StructType\Feedback
     */
    public function setFeedbacktime($feedbacktime = null)
    {
        // validation for constraint: string
        if (!is_null($feedbacktime) && !is_string($feedbacktime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feedbacktime, true), gettype($feedbacktime)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($feedbacktime) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $feedbacktime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($feedbacktime, true)), __LINE__);
        }
        $this->feedbacktime = $feedbacktime;
        return $this;
    }
    /**
     * Get location value
     * @return string
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param string $location
     * @return \StructType\Feedback
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location, true), gettype($location)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($location) && !preg_match('/([-+]){0,1}([0-9])*/', $location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($location, true)), __LINE__);
        }
        $this->location = $location;
        return $this;
    }
    /**
     * Get sleepquality value
     * @return string
     */
    public function getSleepquality()
    {
        return $this->sleepquality;
    }
    /**
     * Set sleepquality value
     * @param string $sleepquality
     * @return \StructType\Feedback
     */
    public function setSleepquality($sleepquality = null)
    {
        // validation for constraint: string
        if (!is_null($sleepquality) && !is_string($sleepquality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sleepquality, true), gettype($sleepquality)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($sleepquality) && !preg_match('/([-+]){0,1}([0-9])*/', $sleepquality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($sleepquality, true)), __LINE__);
        }
        $this->sleepquality = $sleepquality;
        return $this;
    }
    /**
     * Get feedbackservice value
     * @return string
     */
    public function getFeedbackservice()
    {
        return $this->feedbackservice;
    }
    /**
     * Set feedbackservice value
     * @param string $feedbackservice
     * @return \StructType\Feedback
     */
    public function setFeedbackservice($feedbackservice = null)
    {
        // validation for constraint: string
        if (!is_null($feedbackservice) && !is_string($feedbackservice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feedbackservice, true), gettype($feedbackservice)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($feedbackservice) && !preg_match('/([-+]){0,1}([0-9])*/', $feedbackservice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($feedbackservice, true)), __LINE__);
        }
        $this->feedbackservice = $feedbackservice;
        return $this;
    }
    /**
     * Get cleanliness value
     * @return string
     */
    public function getCleanliness()
    {
        return $this->cleanliness;
    }
    /**
     * Set cleanliness value
     * @param string $cleanliness
     * @return \StructType\Feedback
     */
    public function setCleanliness($cleanliness = null)
    {
        // validation for constraint: string
        if (!is_null($cleanliness) && !is_string($cleanliness)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cleanliness, true), gettype($cleanliness)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($cleanliness) && !preg_match('/([-+]){0,1}([0-9])*/', $cleanliness)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($cleanliness, true)), __LINE__);
        }
        $this->cleanliness = $cleanliness;
        return $this;
    }
    /**
     * Get rooms value
     * @return string
     */
    public function getRooms()
    {
        return $this->rooms;
    }
    /**
     * Set rooms value
     * @param string $rooms
     * @return \StructType\Feedback
     */
    public function setRooms($rooms = null)
    {
        // validation for constraint: string
        if (!is_null($rooms) && !is_string($rooms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rooms, true), gettype($rooms)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($rooms) && !preg_match('/([-+]){0,1}([0-9])*/', $rooms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($rooms, true)), __LINE__);
        }
        $this->rooms = $rooms;
        return $this;
    }
    /**
     * Get priceperformance value
     * @return string
     */
    public function getPriceperformance()
    {
        return $this->priceperformance;
    }
    /**
     * Set priceperformance value
     * @param string $priceperformance
     * @return \StructType\Feedback
     */
    public function setPriceperformance($priceperformance = null)
    {
        // validation for constraint: string
        if (!is_null($priceperformance) && !is_string($priceperformance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceperformance, true), gettype($priceperformance)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($priceperformance) && !preg_match('/([-+]){0,1}([0-9])*/', $priceperformance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($priceperformance, true)), __LINE__);
        }
        $this->priceperformance = $priceperformance;
        return $this;
    }
    /**
     * Get text value
     * @return string
     */
    public function getText()
    {
        return $this->text;
    }
    /**
     * Set text value
     * @param string $text
     * @return \StructType\Feedback
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        $this->text = $text;
        return $this;
    }
}
