<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FOServicePosting StructType
 * @subpackage Structs
 */
class FOServicePosting extends AbstractStructBase
{
    /**
     * The POSTING_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $POSTING_OBJID;
    /**
     * The reasonforcancellation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $reasonforcancellation;
    /**
     * Constructor method for FOServicePosting
     * @uses FOServicePosting::setPOSTING_OBJID()
     * @uses FOServicePosting::setReasonforcancellation()
     * @param string $pOSTING_OBJID
     * @param string $reasonforcancellation
     */
    public function __construct($pOSTING_OBJID = null, $reasonforcancellation = null)
    {
        $this
            ->setPOSTING_OBJID($pOSTING_OBJID)
            ->setReasonforcancellation($reasonforcancellation);
    }
    /**
     * Get POSTING_OBJID value
     * @return string
     */
    public function getPOSTING_OBJID()
    {
        return $this->{'POSTING-OBJID'};
    }
    /**
     * Set POSTING_OBJID value
     * @param string $pOSTING_OBJID
     * @return \StructType\FOServicePosting
     */
    public function setPOSTING_OBJID($pOSTING_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($pOSTING_OBJID) && !is_string($pOSTING_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pOSTING_OBJID, true), gettype($pOSTING_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($pOSTING_OBJID) && !preg_match('/([0-9])*/', $pOSTING_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($pOSTING_OBJID, true)), __LINE__);
        }
        $this->POSTING_OBJID = $this->{'POSTING-OBJID'} = $pOSTING_OBJID;
        return $this;
    }
    /**
     * Get reasonforcancellation value
     * @return string|null
     */
    public function getReasonforcancellation()
    {
        return $this->reasonforcancellation;
    }
    /**
     * Set reasonforcancellation value
     * @param string $reasonforcancellation
     * @return \StructType\FOServicePosting
     */
    public function setReasonforcancellation($reasonforcancellation = null)
    {
        // validation for constraint: string
        if (!is_null($reasonforcancellation) && !is_string($reasonforcancellation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonforcancellation, true), gettype($reasonforcancellation)), __LINE__);
        }
        $this->reasonforcancellation = $reasonforcancellation;
        return $this;
    }
}
