<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FEATURE StructType
 * @subpackage Structs
 */
class FEATURE extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $id;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $name;
    /**
     * The isenabled
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $isenabled;
    /**
     * Constructor method for FEATURE
     * @uses FEATURE::setId()
     * @uses FEATURE::setName()
     * @uses FEATURE::setIsenabled()
     * @param string $id
     * @param string $name
     * @param string $isenabled
     */
    public function __construct($id = null, $name = null, $isenabled = null)
    {
        $this
            ->setId($id)
            ->setName($name)
            ->setIsenabled($isenabled);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\FEATURE
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($id) && !preg_match('/([-+]){0,1}([0-9])*/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($id, true)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\FEATURE
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get isenabled value
     * @return string
     */
    public function getIsenabled()
    {
        return $this->isenabled;
    }
    /**
     * Set isenabled value
     * @param string $isenabled
     * @return \StructType\FEATURE
     */
    public function setIsenabled($isenabled = null)
    {
        // validation for constraint: string
        if (!is_null($isenabled) && !is_string($isenabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isenabled, true), gettype($isenabled)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($isenabled) && !preg_match('/([-+]){0,1}([0-9])*/', $isenabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($isenabled, true)), __LINE__);
        }
        $this->isenabled = $isenabled;
        return $this;
    }
}
