<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExternalFile StructType
 * @subpackage Structs
 */
class ExternalFile extends AbstractStructBase
{
    /**
     * The refobjid
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $refobjid;
    /**
     * The trailtype
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $trailtype;
    /**
     * The Node1Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Node1Type;
    /**
     * The ExternalAttachment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ExternalAttachment
     */
    public $ExternalAttachment;
    /**
     * The ExternalFileData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ExternalFileData[]
     */
    public $ExternalFileData;
    /**
     * The Node2Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Node2Type;
    /**
     * Constructor method for ExternalFile
     * @uses ExternalFile::setRefobjid()
     * @uses ExternalFile::setTrailtype()
     * @uses ExternalFile::setNode1Type()
     * @uses ExternalFile::setExternalAttachment()
     * @uses ExternalFile::setExternalFileData()
     * @uses ExternalFile::setNode2Type()
     * @param string $refobjid
     * @param string $trailtype
     * @param string $node1Type
     * @param \StructType\ExternalAttachment $externalAttachment
     * @param \StructType\ExternalFileData[] $externalFileData
     * @param string $node2Type
     */
    public function __construct($refobjid = null, $trailtype = null, $node1Type = null, \StructType\ExternalAttachment $externalAttachment = null, array $externalFileData = array(), $node2Type = null)
    {
        $this
            ->setRefobjid($refobjid)
            ->setTrailtype($trailtype)
            ->setNode1Type($node1Type)
            ->setExternalAttachment($externalAttachment)
            ->setExternalFileData($externalFileData)
            ->setNode2Type($node2Type);
    }
    /**
     * Get refobjid value
     * @return string
     */
    public function getRefobjid()
    {
        return $this->refobjid;
    }
    /**
     * Set refobjid value
     * @param string $refobjid
     * @return \StructType\ExternalFile
     */
    public function setRefobjid($refobjid = null)
    {
        // validation for constraint: string
        if (!is_null($refobjid) && !is_string($refobjid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refobjid, true), gettype($refobjid)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($refobjid) && !preg_match('/([0-9])*/', $refobjid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($refobjid, true)), __LINE__);
        }
        $this->refobjid = $refobjid;
        return $this;
    }
    /**
     * Get trailtype value
     * @return string
     */
    public function getTrailtype()
    {
        return $this->trailtype;
    }
    /**
     * Set trailtype value
     * @param string $trailtype
     * @return \StructType\ExternalFile
     */
    public function setTrailtype($trailtype = null)
    {
        // validation for constraint: string
        if (!is_null($trailtype) && !is_string($trailtype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trailtype, true), gettype($trailtype)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($trailtype) && !preg_match('/([-+]){0,1}([0-9])*/', $trailtype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($trailtype, true)), __LINE__);
        }
        $this->trailtype = $trailtype;
        return $this;
    }
    /**
     * Get Node1Type value
     * @return string
     */
    public function getNode1Type()
    {
        return $this->Node1Type;
    }
    /**
     * Set Node1Type value
     * @param string $node1Type
     * @return \StructType\ExternalFile
     */
    public function setNode1Type($node1Type = null)
    {
        // validation for constraint: string
        if (!is_null($node1Type) && !is_string($node1Type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($node1Type, true), gettype($node1Type)), __LINE__);
        }
        $this->Node1Type = $node1Type;
        return $this;
    }
    /**
     * Get ExternalAttachment value
     * @return \StructType\ExternalAttachment
     */
    public function getExternalAttachment()
    {
        return $this->ExternalAttachment;
    }
    /**
     * Set ExternalAttachment value
     * @param \StructType\ExternalAttachment $externalAttachment
     * @return \StructType\ExternalFile
     */
    public function setExternalAttachment(\StructType\ExternalAttachment $externalAttachment = null)
    {
        $this->ExternalAttachment = $externalAttachment;
        return $this;
    }
    /**
     * Get ExternalFileData value
     * @return \StructType\ExternalFileData[]|null
     */
    public function getExternalFileData()
    {
        return $this->ExternalFileData;
    }
    /**
     * This method is responsible for validating the values passed to the setExternalFileData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternalFileData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternalFileDataForArrayConstraintsFromSetExternalFileData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $externalFileExternalFileDataItem) {
            // validation for constraint: itemType
            if (!$externalFileExternalFileDataItem instanceof \StructType\ExternalFileData) {
                $invalidValues[] = is_object($externalFileExternalFileDataItem) ? get_class($externalFileExternalFileDataItem) : sprintf('%s(%s)', gettype($externalFileExternalFileDataItem), var_export($externalFileExternalFileDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ExternalFileData property can only contain items of type \StructType\ExternalFileData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ExternalFileData value
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalFileData[] $externalFileData
     * @return \StructType\ExternalFile
     */
    public function setExternalFileData(array $externalFileData = array())
    {
        // validation for constraint: array
        if ('' !== ($externalFileDataArrayErrorMessage = self::validateExternalFileDataForArrayConstraintsFromSetExternalFileData($externalFileData))) {
            throw new \InvalidArgumentException($externalFileDataArrayErrorMessage, __LINE__);
        }
        $this->ExternalFileData = $externalFileData;
        return $this;
    }
    /**
     * Add item to ExternalFileData value
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalFileData $item
     * @return \StructType\ExternalFile
     */
    public function addToExternalFileData(\StructType\ExternalFileData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExternalFileData) {
            throw new \InvalidArgumentException(sprintf('The ExternalFileData property can only contain items of type \StructType\ExternalFileData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ExternalFileData[] = $item;
        return $this;
    }
    /**
     * Get Node2Type value
     * @return string|null
     */
    public function getNode2Type()
    {
        return $this->Node2Type;
    }
    /**
     * Set Node2Type value
     * @param string $node2Type
     * @return \StructType\ExternalFile
     */
    public function setNode2Type($node2Type = null)
    {
        // validation for constraint: string
        if (!is_null($node2Type) && !is_string($node2Type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($node2Type, true), gettype($node2Type)), __LINE__);
        }
        $this->Node2Type = $node2Type;
        return $this;
    }
}
