<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventRoomMasterFile StructType
 * @subpackage Structs
 */
class EventRoomMasterFile extends AbstractStructBase
{
    /**
     * The EVENT_ROOM_MASTER_FILE_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $EVENT_ROOM_MASTER_FILE_OBJID;
    /**
     * The eventroom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 6
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $eventroom;
    /**
     * The MultiLangDescriptions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MultiLangDescriptions[]
     */
    public $MultiLangDescriptions;
    /**
     * The MultiLangComments
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MultiLangComments[]
     */
    public $MultiLangComments;
    /**
     * Constructor method for EventRoomMasterFile
     * @uses EventRoomMasterFile::setEVENT_ROOM_MASTER_FILE_OBJID()
     * @uses EventRoomMasterFile::setEventroom()
     * @uses EventRoomMasterFile::setMultiLangDescriptions()
     * @uses EventRoomMasterFile::setMultiLangComments()
     * @param string $eVENT_ROOM_MASTER_FILE_OBJID
     * @param string $eventroom
     * @param \StructType\MultiLangDescriptions[] $multiLangDescriptions
     * @param \StructType\MultiLangComments[] $multiLangComments
     */
    public function __construct($eVENT_ROOM_MASTER_FILE_OBJID = null, $eventroom = null, array $multiLangDescriptions = array(), array $multiLangComments = array())
    {
        $this
            ->setEVENT_ROOM_MASTER_FILE_OBJID($eVENT_ROOM_MASTER_FILE_OBJID)
            ->setEventroom($eventroom)
            ->setMultiLangDescriptions($multiLangDescriptions)
            ->setMultiLangComments($multiLangComments);
    }
    /**
     * Get EVENT_ROOM_MASTER_FILE_OBJID value
     * @return string
     */
    public function getEVENT_ROOM_MASTER_FILE_OBJID()
    {
        return $this->{'EVENT-ROOM-MASTER-FILE-OBJID'};
    }
    /**
     * Set EVENT_ROOM_MASTER_FILE_OBJID value
     * @param string $eVENT_ROOM_MASTER_FILE_OBJID
     * @return \StructType\EventRoomMasterFile
     */
    public function setEVENT_ROOM_MASTER_FILE_OBJID($eVENT_ROOM_MASTER_FILE_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($eVENT_ROOM_MASTER_FILE_OBJID) && !is_string($eVENT_ROOM_MASTER_FILE_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eVENT_ROOM_MASTER_FILE_OBJID, true), gettype($eVENT_ROOM_MASTER_FILE_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($eVENT_ROOM_MASTER_FILE_OBJID) && !preg_match('/([0-9])*/', $eVENT_ROOM_MASTER_FILE_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($eVENT_ROOM_MASTER_FILE_OBJID, true)), __LINE__);
        }
        $this->EVENT_ROOM_MASTER_FILE_OBJID = $this->{'EVENT-ROOM-MASTER-FILE-OBJID'} = $eVENT_ROOM_MASTER_FILE_OBJID;
        return $this;
    }
    /**
     * Get eventroom value
     * @return string
     */
    public function getEventroom()
    {
        return $this->eventroom;
    }
    /**
     * Set eventroom value
     * @param string $eventroom
     * @return \StructType\EventRoomMasterFile
     */
    public function setEventroom($eventroom = null)
    {
        // validation for constraint: string
        if (!is_null($eventroom) && !is_string($eventroom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventroom, true), gettype($eventroom)), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (!is_null($eventroom) && mb_strlen($eventroom) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen($eventroom)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($eventroom) && mb_strlen($eventroom) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($eventroom)), __LINE__);
        }
        $this->eventroom = $eventroom;
        return $this;
    }
    /**
     * Get MultiLangDescriptions value
     * @return \StructType\MultiLangDescriptions[]|null
     */
    public function getMultiLangDescriptions()
    {
        return $this->MultiLangDescriptions;
    }
    /**
     * This method is responsible for validating the values passed to the setMultiLangDescriptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMultiLangDescriptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMultiLangDescriptionsForArrayConstraintsFromSetMultiLangDescriptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eventRoomMasterFileMultiLangDescriptionsItem) {
            // validation for constraint: itemType
            if (!$eventRoomMasterFileMultiLangDescriptionsItem instanceof \StructType\MultiLangDescriptions) {
                $invalidValues[] = is_object($eventRoomMasterFileMultiLangDescriptionsItem) ? get_class($eventRoomMasterFileMultiLangDescriptionsItem) : sprintf('%s(%s)', gettype($eventRoomMasterFileMultiLangDescriptionsItem), var_export($eventRoomMasterFileMultiLangDescriptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MultiLangDescriptions property can only contain items of type \StructType\MultiLangDescriptions, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MultiLangDescriptions value
     * @throws \InvalidArgumentException
     * @param \StructType\MultiLangDescriptions[] $multiLangDescriptions
     * @return \StructType\EventRoomMasterFile
     */
    public function setMultiLangDescriptions(array $multiLangDescriptions = array())
    {
        // validation for constraint: array
        if ('' !== ($multiLangDescriptionsArrayErrorMessage = self::validateMultiLangDescriptionsForArrayConstraintsFromSetMultiLangDescriptions($multiLangDescriptions))) {
            throw new \InvalidArgumentException($multiLangDescriptionsArrayErrorMessage, __LINE__);
        }
        $this->MultiLangDescriptions = $multiLangDescriptions;
        return $this;
    }
    /**
     * Add item to MultiLangDescriptions value
     * @throws \InvalidArgumentException
     * @param \StructType\MultiLangDescriptions $item
     * @return \StructType\EventRoomMasterFile
     */
    public function addToMultiLangDescriptions(\StructType\MultiLangDescriptions $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MultiLangDescriptions) {
            throw new \InvalidArgumentException(sprintf('The MultiLangDescriptions property can only contain items of type \StructType\MultiLangDescriptions, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MultiLangDescriptions[] = $item;
        return $this;
    }
    /**
     * Get MultiLangComments value
     * @return \StructType\MultiLangComments[]|null
     */
    public function getMultiLangComments()
    {
        return $this->MultiLangComments;
    }
    /**
     * This method is responsible for validating the values passed to the setMultiLangComments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMultiLangComments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMultiLangCommentsForArrayConstraintsFromSetMultiLangComments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eventRoomMasterFileMultiLangCommentsItem) {
            // validation for constraint: itemType
            if (!$eventRoomMasterFileMultiLangCommentsItem instanceof \StructType\MultiLangComments) {
                $invalidValues[] = is_object($eventRoomMasterFileMultiLangCommentsItem) ? get_class($eventRoomMasterFileMultiLangCommentsItem) : sprintf('%s(%s)', gettype($eventRoomMasterFileMultiLangCommentsItem), var_export($eventRoomMasterFileMultiLangCommentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MultiLangComments property can only contain items of type \StructType\MultiLangComments, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MultiLangComments value
     * @throws \InvalidArgumentException
     * @param \StructType\MultiLangComments[] $multiLangComments
     * @return \StructType\EventRoomMasterFile
     */
    public function setMultiLangComments(array $multiLangComments = array())
    {
        // validation for constraint: array
        if ('' !== ($multiLangCommentsArrayErrorMessage = self::validateMultiLangCommentsForArrayConstraintsFromSetMultiLangComments($multiLangComments))) {
            throw new \InvalidArgumentException($multiLangCommentsArrayErrorMessage, __LINE__);
        }
        $this->MultiLangComments = $multiLangComments;
        return $this;
    }
    /**
     * Add item to MultiLangComments value
     * @throws \InvalidArgumentException
     * @param \StructType\MultiLangComments $item
     * @return \StructType\EventRoomMasterFile
     */
    public function addToMultiLangComments(\StructType\MultiLangComments $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MultiLangComments) {
            throw new \InvalidArgumentException(sprintf('The MultiLangComments property can only contain items of type \StructType\MultiLangComments, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MultiLangComments[] = $item;
        return $this;
    }
}
