<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Entry StructType
 * @subpackage Structs
 */
class Entry extends AbstractStructBase
{
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Key;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Value;
    /**
     * The Sorting
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $Sorting;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Language;
    /**
     * Constructor method for Entry
     * @uses Entry::setKey()
     * @uses Entry::setValue()
     * @uses Entry::setSorting()
     * @uses Entry::setLanguage()
     * @param string $key
     * @param string $value
     * @param string $sorting
     * @param string $language
     */
    public function __construct($key = null, $value = null, $sorting = null, $language = null)
    {
        $this
            ->setKey($key)
            ->setValue($value)
            ->setSorting($sorting)
            ->setLanguage($language);
    }
    /**
     * Get Key value
     * @return string
     */
    public function getKey()
    {
        return $this->Key;
    }
    /**
     * Set Key value
     * @param string $key
     * @return \StructType\Entry
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        $this->Key = $key;
        return $this;
    }
    /**
     * Get Value value
     * @return string
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \StructType\Entry
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Sorting value
     * @return string
     */
    public function getSorting()
    {
        return $this->Sorting;
    }
    /**
     * Set Sorting value
     * @param string $sorting
     * @return \StructType\Entry
     */
    public function setSorting($sorting = null)
    {
        // validation for constraint: string
        if (!is_null($sorting) && !is_string($sorting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sorting, true), gettype($sorting)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($sorting) && mb_strlen($sorting) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($sorting)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($sorting) && mb_strlen($sorting) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($sorting)), __LINE__);
        }
        $this->Sorting = $sorting;
        return $this;
    }
    /**
     * Get Language value
     * @return string
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\Entry
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
}
