<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Deposit StructType
 * @subpackage Structs
 */
class Deposit_1 extends AbstractStructBase
{
    /**
     * The ResAccounts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ResAccounts
     */
    public $ResAccounts;
    /**
     * The DepositInvoice
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DepositInvoice[]
     */
    public $DepositInvoice;
    /**
     * The DepositCredit
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DepositCredit[]
     */
    public $DepositCredit;
    /**
     * Constructor method for Deposit
     * @uses Deposit_1::setResAccounts()
     * @uses Deposit_1::setDepositInvoice()
     * @uses Deposit_1::setDepositCredit()
     * @param \StructType\ResAccounts $resAccounts
     * @param \StructType\DepositInvoice[] $depositInvoice
     * @param \StructType\DepositCredit[] $depositCredit
     */
    public function __construct(\StructType\ResAccounts $resAccounts = null, array $depositInvoice = array(), array $depositCredit = array())
    {
        $this
            ->setResAccounts($resAccounts)
            ->setDepositInvoice($depositInvoice)
            ->setDepositCredit($depositCredit);
    }
    /**
     * Get ResAccounts value
     * @return \StructType\ResAccounts
     */
    public function getResAccounts()
    {
        return $this->ResAccounts;
    }
    /**
     * Set ResAccounts value
     * @param \StructType\ResAccounts $resAccounts
     * @return \StructType\Deposit_1
     */
    public function setResAccounts(\StructType\ResAccounts $resAccounts = null)
    {
        $this->ResAccounts = $resAccounts;
        return $this;
    }
    /**
     * Get DepositInvoice value
     * @return \StructType\DepositInvoice[]|null
     */
    public function getDepositInvoice()
    {
        return $this->DepositInvoice;
    }
    /**
     * This method is responsible for validating the values passed to the setDepositInvoice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDepositInvoice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDepositInvoiceForArrayConstraintsFromSetDepositInvoice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $depositDepositInvoiceItem) {
            // validation for constraint: itemType
            if (!$depositDepositInvoiceItem instanceof \StructType\DepositInvoice) {
                $invalidValues[] = is_object($depositDepositInvoiceItem) ? get_class($depositDepositInvoiceItem) : sprintf('%s(%s)', gettype($depositDepositInvoiceItem), var_export($depositDepositInvoiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DepositInvoice property can only contain items of type \StructType\DepositInvoice, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DepositInvoice value
     * @throws \InvalidArgumentException
     * @param \StructType\DepositInvoice[] $depositInvoice
     * @return \StructType\Deposit_1
     */
    public function setDepositInvoice(array $depositInvoice = array())
    {
        // validation for constraint: array
        if ('' !== ($depositInvoiceArrayErrorMessage = self::validateDepositInvoiceForArrayConstraintsFromSetDepositInvoice($depositInvoice))) {
            throw new \InvalidArgumentException($depositInvoiceArrayErrorMessage, __LINE__);
        }
        $this->DepositInvoice = $depositInvoice;
        return $this;
    }
    /**
     * Add item to DepositInvoice value
     * @throws \InvalidArgumentException
     * @param \StructType\DepositInvoice $item
     * @return \StructType\Deposit_1
     */
    public function addToDepositInvoice(\StructType\DepositInvoice $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DepositInvoice) {
            throw new \InvalidArgumentException(sprintf('The DepositInvoice property can only contain items of type \StructType\DepositInvoice, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DepositInvoice[] = $item;
        return $this;
    }
    /**
     * Get DepositCredit value
     * @return \StructType\DepositCredit[]|null
     */
    public function getDepositCredit()
    {
        return $this->DepositCredit;
    }
    /**
     * This method is responsible for validating the values passed to the setDepositCredit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDepositCredit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDepositCreditForArrayConstraintsFromSetDepositCredit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $depositDepositCreditItem) {
            // validation for constraint: itemType
            if (!$depositDepositCreditItem instanceof \StructType\DepositCredit) {
                $invalidValues[] = is_object($depositDepositCreditItem) ? get_class($depositDepositCreditItem) : sprintf('%s(%s)', gettype($depositDepositCreditItem), var_export($depositDepositCreditItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DepositCredit property can only contain items of type \StructType\DepositCredit, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DepositCredit value
     * @throws \InvalidArgumentException
     * @param \StructType\DepositCredit[] $depositCredit
     * @return \StructType\Deposit_1
     */
    public function setDepositCredit(array $depositCredit = array())
    {
        // validation for constraint: array
        if ('' !== ($depositCreditArrayErrorMessage = self::validateDepositCreditForArrayConstraintsFromSetDepositCredit($depositCredit))) {
            throw new \InvalidArgumentException($depositCreditArrayErrorMessage, __LINE__);
        }
        $this->DepositCredit = $depositCredit;
        return $this;
    }
    /**
     * Add item to DepositCredit value
     * @throws \InvalidArgumentException
     * @param \StructType\DepositCredit $item
     * @return \StructType\Deposit_1
     */
    public function addToDepositCredit(\StructType\DepositCredit $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DepositCredit) {
            throw new \InvalidArgumentException(sprintf('The DepositCredit property can only contain items of type \StructType\DepositCredit, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DepositCredit[] = $item;
        return $this;
    }
}
