<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DELIVERY-ADDRESS StructType
 * @subpackage Structs
 */
class DELIVERY_ADDRESS extends AbstractStructBase
{
    /**
     * The name1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $name1;
    /**
     * The name2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $name2;
    /**
     * The DELIVERY_ADDRESS_CONTACT_PERSON_OBJID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DELIVERY_ADDRESS_CONTACT_PERSON_OBJID;
    /**
     * The DELIVERY_ADDRESS_CONTACTPERSON_OBJID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DELIVERY_ADDRESS_CONTACTPERSON_OBJID;
    /**
     * The DELIVERY_ADDRESS_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9])*
     * @var string
     */
    public $DELIVERY_ADDRESS_OBJID;
    /**
     * The DELIVERY_ADDRESS_CENTRALID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9])*
     * @var string
     */
    public $DELIVERY_ADDRESS_CENTRALID;
    /**
     * The DELIVERY_ADDRESS_GUEST_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9])*
     * @var string
     */
    public $DELIVERY_ADDRESS_GUEST_OBJID;
    /**
     * Constructor method for DELIVERY-ADDRESS
     * @uses DELIVERY_ADDRESS::setName1()
     * @uses DELIVERY_ADDRESS::setName2()
     * @uses DELIVERY_ADDRESS::setDELIVERY_ADDRESS_CONTACT_PERSON_OBJID()
     * @uses DELIVERY_ADDRESS::setDELIVERY_ADDRESS_CONTACTPERSON_OBJID()
     * @uses DELIVERY_ADDRESS::setDELIVERY_ADDRESS_OBJID()
     * @uses DELIVERY_ADDRESS::setDELIVERY_ADDRESS_CENTRALID()
     * @uses DELIVERY_ADDRESS::setDELIVERY_ADDRESS_GUEST_OBJID()
     * @param string $name1
     * @param string $name2
     * @param string $dELIVERY_ADDRESS_CONTACT_PERSON_OBJID
     * @param string $dELIVERY_ADDRESS_CONTACTPERSON_OBJID
     * @param string $dELIVERY_ADDRESS_OBJID
     * @param string $dELIVERY_ADDRESS_CENTRALID
     * @param string $dELIVERY_ADDRESS_GUEST_OBJID
     */
    public function __construct($name1 = null, $name2 = null, $dELIVERY_ADDRESS_CONTACT_PERSON_OBJID = null, $dELIVERY_ADDRESS_CONTACTPERSON_OBJID = null, $dELIVERY_ADDRESS_OBJID = null, $dELIVERY_ADDRESS_CENTRALID = null, $dELIVERY_ADDRESS_GUEST_OBJID = null)
    {
        $this
            ->setName1($name1)
            ->setName2($name2)
            ->setDELIVERY_ADDRESS_CONTACT_PERSON_OBJID($dELIVERY_ADDRESS_CONTACT_PERSON_OBJID)
            ->setDELIVERY_ADDRESS_CONTACTPERSON_OBJID($dELIVERY_ADDRESS_CONTACTPERSON_OBJID)
            ->setDELIVERY_ADDRESS_OBJID($dELIVERY_ADDRESS_OBJID)
            ->setDELIVERY_ADDRESS_CENTRALID($dELIVERY_ADDRESS_CENTRALID)
            ->setDELIVERY_ADDRESS_GUEST_OBJID($dELIVERY_ADDRESS_GUEST_OBJID);
    }
    /**
     * Get name1 value
     * @return string
     */
    public function getName1()
    {
        return $this->name1;
    }
    /**
     * Set name1 value
     * @param string $name1
     * @return \StructType\DELIVERY_ADDRESS
     */
    public function setName1($name1 = null)
    {
        // validation for constraint: string
        if (!is_null($name1) && !is_string($name1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name1, true), gettype($name1)), __LINE__);
        }
        $this->name1 = $name1;
        return $this;
    }
    /**
     * Get name2 value
     * @return string
     */
    public function getName2()
    {
        return $this->name2;
    }
    /**
     * Set name2 value
     * @param string $name2
     * @return \StructType\DELIVERY_ADDRESS
     */
    public function setName2($name2 = null)
    {
        // validation for constraint: string
        if (!is_null($name2) && !is_string($name2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name2, true), gettype($name2)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($name2) && mb_strlen($name2) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($name2)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($name2) && mb_strlen($name2) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($name2)), __LINE__);
        }
        $this->name2 = $name2;
        return $this;
    }
    /**
     * Get DELIVERY_ADDRESS_CONTACT_PERSON_OBJID value
     * @return string
     */
    public function getDELIVERY_ADDRESS_CONTACT_PERSON_OBJID()
    {
        return $this->{'DELIVERY-ADDRESS-CONTACT-PERSON-OBJID'};
    }
    /**
     * Set DELIVERY_ADDRESS_CONTACT_PERSON_OBJID value
     * @param string $dELIVERY_ADDRESS_CONTACT_PERSON_OBJID
     * @return \StructType\DELIVERY_ADDRESS
     */
    public function setDELIVERY_ADDRESS_CONTACT_PERSON_OBJID($dELIVERY_ADDRESS_CONTACT_PERSON_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($dELIVERY_ADDRESS_CONTACT_PERSON_OBJID) && !is_string($dELIVERY_ADDRESS_CONTACT_PERSON_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dELIVERY_ADDRESS_CONTACT_PERSON_OBJID, true), gettype($dELIVERY_ADDRESS_CONTACT_PERSON_OBJID)), __LINE__);
        }
        $this->DELIVERY_ADDRESS_CONTACT_PERSON_OBJID = $this->{'DELIVERY-ADDRESS-CONTACT-PERSON-OBJID'} = $dELIVERY_ADDRESS_CONTACT_PERSON_OBJID;
        return $this;
    }
    /**
     * Get DELIVERY_ADDRESS_CONTACTPERSON_OBJID value
     * @return string
     */
    public function getDELIVERY_ADDRESS_CONTACTPERSON_OBJID()
    {
        return $this->{'DELIVERY-ADDRESS-CONTACTPERSON-OBJID'};
    }
    /**
     * Set DELIVERY_ADDRESS_CONTACTPERSON_OBJID value
     * @param string $dELIVERY_ADDRESS_CONTACTPERSON_OBJID
     * @return \StructType\DELIVERY_ADDRESS
     */
    public function setDELIVERY_ADDRESS_CONTACTPERSON_OBJID($dELIVERY_ADDRESS_CONTACTPERSON_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($dELIVERY_ADDRESS_CONTACTPERSON_OBJID) && !is_string($dELIVERY_ADDRESS_CONTACTPERSON_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dELIVERY_ADDRESS_CONTACTPERSON_OBJID, true), gettype($dELIVERY_ADDRESS_CONTACTPERSON_OBJID)), __LINE__);
        }
        $this->DELIVERY_ADDRESS_CONTACTPERSON_OBJID = $this->{'DELIVERY-ADDRESS-CONTACTPERSON-OBJID'} = $dELIVERY_ADDRESS_CONTACTPERSON_OBJID;
        return $this;
    }
    /**
     * Get DELIVERY_ADDRESS_OBJID value
     * @return string|null
     */
    public function getDELIVERY_ADDRESS_OBJID()
    {
        return $this->{'DELIVERY-ADDRESS-OBJID'};
    }
    /**
     * Set DELIVERY_ADDRESS_OBJID value
     * @param string $dELIVERY_ADDRESS_OBJID
     * @return \StructType\DELIVERY_ADDRESS
     */
    public function setDELIVERY_ADDRESS_OBJID($dELIVERY_ADDRESS_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($dELIVERY_ADDRESS_OBJID) && !is_string($dELIVERY_ADDRESS_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dELIVERY_ADDRESS_OBJID, true), gettype($dELIVERY_ADDRESS_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($dELIVERY_ADDRESS_OBJID) && !preg_match('/([0-9])*/', $dELIVERY_ADDRESS_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($dELIVERY_ADDRESS_OBJID, true)), __LINE__);
        }
        $this->DELIVERY_ADDRESS_OBJID = $this->{'DELIVERY-ADDRESS-OBJID'} = $dELIVERY_ADDRESS_OBJID;
        return $this;
    }
    /**
     * Get DELIVERY_ADDRESS_CENTRALID value
     * @return string|null
     */
    public function getDELIVERY_ADDRESS_CENTRALID()
    {
        return $this->{'DELIVERY-ADDRESS-CENTRALID'};
    }
    /**
     * Set DELIVERY_ADDRESS_CENTRALID value
     * @param string $dELIVERY_ADDRESS_CENTRALID
     * @return \StructType\DELIVERY_ADDRESS
     */
    public function setDELIVERY_ADDRESS_CENTRALID($dELIVERY_ADDRESS_CENTRALID = null)
    {
        // validation for constraint: string
        if (!is_null($dELIVERY_ADDRESS_CENTRALID) && !is_string($dELIVERY_ADDRESS_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dELIVERY_ADDRESS_CENTRALID, true), gettype($dELIVERY_ADDRESS_CENTRALID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($dELIVERY_ADDRESS_CENTRALID) && !preg_match('/([0-9])*/', $dELIVERY_ADDRESS_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($dELIVERY_ADDRESS_CENTRALID, true)), __LINE__);
        }
        $this->DELIVERY_ADDRESS_CENTRALID = $this->{'DELIVERY-ADDRESS-CENTRALID'} = $dELIVERY_ADDRESS_CENTRALID;
        return $this;
    }
    /**
     * Get DELIVERY_ADDRESS_GUEST_OBJID value
     * @return string|null
     */
    public function getDELIVERY_ADDRESS_GUEST_OBJID()
    {
        return $this->{'DELIVERY-ADDRESS-GUEST-OBJID'};
    }
    /**
     * Set DELIVERY_ADDRESS_GUEST_OBJID value
     * @param string $dELIVERY_ADDRESS_GUEST_OBJID
     * @return \StructType\DELIVERY_ADDRESS
     */
    public function setDELIVERY_ADDRESS_GUEST_OBJID($dELIVERY_ADDRESS_GUEST_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($dELIVERY_ADDRESS_GUEST_OBJID) && !is_string($dELIVERY_ADDRESS_GUEST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dELIVERY_ADDRESS_GUEST_OBJID, true), gettype($dELIVERY_ADDRESS_GUEST_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($dELIVERY_ADDRESS_GUEST_OBJID) && !preg_match('/([0-9])*/', $dELIVERY_ADDRESS_GUEST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($dELIVERY_ADDRESS_GUEST_OBJID, true)), __LINE__);
        }
        $this->DELIVERY_ADDRESS_GUEST_OBJID = $this->{'DELIVERY-ADDRESS-GUEST-OBJID'} = $dELIVERY_ADDRESS_GUEST_OBJID;
        return $this;
    }
}
