<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DAILYRATERESULT StructType
 * @subpackage Structs
 */
class DAILYRATERESULT extends AbstractStructBase
{
    /**
     * The date
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $date;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $rate;
    /**
     * The discount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $discount;
    /**
     * The currencyamount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $currencyamount;
    /**
     * The currencydiscount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $currencydiscount;
    /**
     * The totalRooms
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $totalRooms;
    /**
     * The occupiedrooms
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $occupiedrooms;
    /**
     * The availablerooms
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $availablerooms;
    /**
     * The occupancyPercentage
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $occupancyPercentage;
    /**
     * Constructor method for DAILYRATERESULT
     * @uses DAILYRATERESULT::setDate()
     * @uses DAILYRATERESULT::setRate()
     * @uses DAILYRATERESULT::setDiscount()
     * @uses DAILYRATERESULT::setCurrencyamount()
     * @uses DAILYRATERESULT::setCurrencydiscount()
     * @uses DAILYRATERESULT::setTotalRooms()
     * @uses DAILYRATERESULT::setOccupiedrooms()
     * @uses DAILYRATERESULT::setAvailablerooms()
     * @uses DAILYRATERESULT::setOccupancyPercentage()
     * @param string $date
     * @param string $rate
     * @param string $discount
     * @param string $currencyamount
     * @param string $currencydiscount
     * @param string $totalRooms
     * @param string $occupiedrooms
     * @param string $availablerooms
     * @param string $occupancyPercentage
     */
    public function __construct($date = null, $rate = null, $discount = null, $currencyamount = null, $currencydiscount = null, $totalRooms = null, $occupiedrooms = null, $availablerooms = null, $occupancyPercentage = null)
    {
        $this
            ->setDate($date)
            ->setRate($rate)
            ->setDiscount($discount)
            ->setCurrencyamount($currencyamount)
            ->setCurrencydiscount($currencydiscount)
            ->setTotalRooms($totalRooms)
            ->setOccupiedrooms($occupiedrooms)
            ->setAvailablerooms($availablerooms)
            ->setOccupancyPercentage($occupancyPercentage);
    }
    /**
     * Get date value
     * @return string
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\DAILYRATERESULT
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($date) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($date, true)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get rate value
     * @return string
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param string $rate
     * @return \StructType\DAILYRATERESULT
     */
    public function setRate($rate = null)
    {
        // validation for constraint: string
        if (!is_null($rate) && !is_string($rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($rate) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($rate, true)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get discount value
     * @return string
     */
    public function getDiscount()
    {
        return $this->discount;
    }
    /**
     * Set discount value
     * @param string $discount
     * @return \StructType\DAILYRATERESULT
     */
    public function setDiscount($discount = null)
    {
        // validation for constraint: string
        if (!is_null($discount) && !is_string($discount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discount, true), gettype($discount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($discount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $discount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($discount, true)), __LINE__);
        }
        $this->discount = $discount;
        return $this;
    }
    /**
     * Get currencyamount value
     * @return string
     */
    public function getCurrencyamount()
    {
        return $this->currencyamount;
    }
    /**
     * Set currencyamount value
     * @param string $currencyamount
     * @return \StructType\DAILYRATERESULT
     */
    public function setCurrencyamount($currencyamount = null)
    {
        // validation for constraint: string
        if (!is_null($currencyamount) && !is_string($currencyamount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyamount, true), gettype($currencyamount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($currencyamount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $currencyamount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($currencyamount, true)), __LINE__);
        }
        $this->currencyamount = $currencyamount;
        return $this;
    }
    /**
     * Get currencydiscount value
     * @return string
     */
    public function getCurrencydiscount()
    {
        return $this->currencydiscount;
    }
    /**
     * Set currencydiscount value
     * @param string $currencydiscount
     * @return \StructType\DAILYRATERESULT
     */
    public function setCurrencydiscount($currencydiscount = null)
    {
        // validation for constraint: string
        if (!is_null($currencydiscount) && !is_string($currencydiscount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencydiscount, true), gettype($currencydiscount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($currencydiscount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $currencydiscount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($currencydiscount, true)), __LINE__);
        }
        $this->currencydiscount = $currencydiscount;
        return $this;
    }
    /**
     * Get totalRooms value
     * @return string
     */
    public function getTotalRooms()
    {
        return $this->totalRooms;
    }
    /**
     * Set totalRooms value
     * @param string $totalRooms
     * @return \StructType\DAILYRATERESULT
     */
    public function setTotalRooms($totalRooms = null)
    {
        // validation for constraint: string
        if (!is_null($totalRooms) && !is_string($totalRooms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalRooms, true), gettype($totalRooms)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($totalRooms) && !preg_match('/([-+]){0,1}([0-9])*/', $totalRooms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($totalRooms, true)), __LINE__);
        }
        $this->totalRooms = $totalRooms;
        return $this;
    }
    /**
     * Get occupiedrooms value
     * @return string
     */
    public function getOccupiedrooms()
    {
        return $this->occupiedrooms;
    }
    /**
     * Set occupiedrooms value
     * @param string $occupiedrooms
     * @return \StructType\DAILYRATERESULT
     */
    public function setOccupiedrooms($occupiedrooms = null)
    {
        // validation for constraint: string
        if (!is_null($occupiedrooms) && !is_string($occupiedrooms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($occupiedrooms, true), gettype($occupiedrooms)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($occupiedrooms) && !preg_match('/([-+]){0,1}([0-9])*/', $occupiedrooms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($occupiedrooms, true)), __LINE__);
        }
        $this->occupiedrooms = $occupiedrooms;
        return $this;
    }
    /**
     * Get availablerooms value
     * @return string
     */
    public function getAvailablerooms()
    {
        return $this->availablerooms;
    }
    /**
     * Set availablerooms value
     * @param string $availablerooms
     * @return \StructType\DAILYRATERESULT
     */
    public function setAvailablerooms($availablerooms = null)
    {
        // validation for constraint: string
        if (!is_null($availablerooms) && !is_string($availablerooms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($availablerooms, true), gettype($availablerooms)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($availablerooms) && !preg_match('/([-+]){0,1}([0-9])*/', $availablerooms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($availablerooms, true)), __LINE__);
        }
        $this->availablerooms = $availablerooms;
        return $this;
    }
    /**
     * Get occupancyPercentage value
     * @return string
     */
    public function getOccupancyPercentage()
    {
        return $this->occupancyPercentage;
    }
    /**
     * Set occupancyPercentage value
     * @param string $occupancyPercentage
     * @return \StructType\DAILYRATERESULT
     */
    public function setOccupancyPercentage($occupancyPercentage = null)
    {
        // validation for constraint: string
        if (!is_null($occupancyPercentage) && !is_string($occupancyPercentage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($occupancyPercentage, true), gettype($occupancyPercentage)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($occupancyPercentage) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $occupancyPercentage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($occupancyPercentage, true)), __LINE__);
        }
        $this->occupancyPercentage = $occupancyPercentage;
        return $this;
    }
}
