<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ComboBox StructType
 * @subpackage Structs
 */
class ComboBox extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Type;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Description;
    /**
     * The Entries
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Entries[]
     */
    public $Entries;
    /**
     * The Entry
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Entry[]
     */
    public $Entry;
    /**
     * Constructor method for ComboBox
     * @uses ComboBox::setType()
     * @uses ComboBox::setDescription()
     * @uses ComboBox::setEntries()
     * @uses ComboBox::setEntry()
     * @param string $type
     * @param string $description
     * @param \StructType\Entries[] $entries
     * @param \StructType\Entry[] $entry
     */
    public function __construct($type = null, $description = null, array $entries = array(), array $entry = array())
    {
        $this
            ->setType($type)
            ->setDescription($description)
            ->setEntries($entries)
            ->setEntry($entry);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\ComboBox
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Description value
     * @return string
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\ComboBox
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Entries value
     * @return \StructType\Entries[]|null
     */
    public function getEntries()
    {
        return $this->Entries;
    }
    /**
     * This method is responsible for validating the values passed to the setEntries method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEntries method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEntriesForArrayConstraintsFromSetEntries(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $comboBoxEntriesItem) {
            // validation for constraint: itemType
            if (!$comboBoxEntriesItem instanceof \StructType\Entries) {
                $invalidValues[] = is_object($comboBoxEntriesItem) ? get_class($comboBoxEntriesItem) : sprintf('%s(%s)', gettype($comboBoxEntriesItem), var_export($comboBoxEntriesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Entries property can only contain items of type \StructType\Entries, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Entries value
     * @throws \InvalidArgumentException
     * @param \StructType\Entries[] $entries
     * @return \StructType\ComboBox
     */
    public function setEntries(array $entries = array())
    {
        // validation for constraint: array
        if ('' !== ($entriesArrayErrorMessage = self::validateEntriesForArrayConstraintsFromSetEntries($entries))) {
            throw new \InvalidArgumentException($entriesArrayErrorMessage, __LINE__);
        }
        $this->Entries = $entries;
        return $this;
    }
    /**
     * Add item to Entries value
     * @throws \InvalidArgumentException
     * @param \StructType\Entries $item
     * @return \StructType\ComboBox
     */
    public function addToEntries(\StructType\Entries $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Entries) {
            throw new \InvalidArgumentException(sprintf('The Entries property can only contain items of type \StructType\Entries, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Entries[] = $item;
        return $this;
    }
    /**
     * Get Entry value
     * @return \StructType\Entry[]|null
     */
    public function getEntry()
    {
        return $this->Entry;
    }
    /**
     * This method is responsible for validating the values passed to the setEntry method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEntry method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEntryForArrayConstraintsFromSetEntry(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $comboBoxEntryItem) {
            // validation for constraint: itemType
            if (!$comboBoxEntryItem instanceof \StructType\Entry) {
                $invalidValues[] = is_object($comboBoxEntryItem) ? get_class($comboBoxEntryItem) : sprintf('%s(%s)', gettype($comboBoxEntryItem), var_export($comboBoxEntryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Entry property can only contain items of type \StructType\Entry, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Entry value
     * @throws \InvalidArgumentException
     * @param \StructType\Entry[] $entry
     * @return \StructType\ComboBox
     */
    public function setEntry(array $entry = array())
    {
        // validation for constraint: array
        if ('' !== ($entryArrayErrorMessage = self::validateEntryForArrayConstraintsFromSetEntry($entry))) {
            throw new \InvalidArgumentException($entryArrayErrorMessage, __LINE__);
        }
        $this->Entry = $entry;
        return $this;
    }
    /**
     * Add item to Entry value
     * @throws \InvalidArgumentException
     * @param \StructType\Entry $item
     * @return \StructType\ComboBox
     */
    public function addToEntry(\StructType\Entry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Entry) {
            throw new \InvalidArgumentException(sprintf('The Entry property can only contain items of type \StructType\Entry, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Entry[] = $item;
        return $this;
    }
}
