<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CategorySearchEntry StructType
 * @subpackage Structs
 */
class CategorySearchEntry extends AbstractStructBase
{
    /**
     * The Category
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $Category;
    /**
     * The Mapping
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Mapping[]
     */
    public $Mapping;
    /**
     * Constructor method for CategorySearchEntry
     * @uses CategorySearchEntry::setCategory()
     * @uses CategorySearchEntry::setMapping()
     * @param string $category
     * @param \StructType\Mapping[] $mapping
     */
    public function __construct($category = null, array $mapping = array())
    {
        $this
            ->setCategory($category)
            ->setMapping($mapping);
    }
    /**
     * Get Category value
     * @return string
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param string $category
     * @return \StructType\CategorySearchEntry
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($category) && mb_strlen($category) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($category)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($category) && mb_strlen($category) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($category)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get Mapping value
     * @return \StructType\Mapping[]|null
     */
    public function getMapping()
    {
        return $this->Mapping;
    }
    /**
     * This method is responsible for validating the values passed to the setMapping method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMapping method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMappingForArrayConstraintsFromSetMapping(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $categorySearchEntryMappingItem) {
            // validation for constraint: itemType
            if (!$categorySearchEntryMappingItem instanceof \StructType\Mapping) {
                $invalidValues[] = is_object($categorySearchEntryMappingItem) ? get_class($categorySearchEntryMappingItem) : sprintf('%s(%s)', gettype($categorySearchEntryMappingItem), var_export($categorySearchEntryMappingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Mapping property can only contain items of type \StructType\Mapping, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Mapping value
     * @throws \InvalidArgumentException
     * @param \StructType\Mapping[] $mapping
     * @return \StructType\CategorySearchEntry
     */
    public function setMapping(array $mapping = array())
    {
        // validation for constraint: array
        if ('' !== ($mappingArrayErrorMessage = self::validateMappingForArrayConstraintsFromSetMapping($mapping))) {
            throw new \InvalidArgumentException($mappingArrayErrorMessage, __LINE__);
        }
        $this->Mapping = $mapping;
        return $this;
    }
    /**
     * Add item to Mapping value
     * @throws \InvalidArgumentException
     * @param \StructType\Mapping $item
     * @return \StructType\CategorySearchEntry
     */
    public function addToMapping(\StructType\Mapping $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Mapping) {
            throw new \InvalidArgumentException(sprintf('The Mapping property can only contain items of type \StructType\Mapping, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Mapping[] = $item;
        return $this;
    }
}
