<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CardSearchAndModify StructType
 * @subpackage Structs
 */
class CardSearchAndModify extends AbstractStructBase
{
    /**
     * The CARD_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $CARD_OBJID;
    /**
     * The CardModifyData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\CardModifyData
     */
    public $CardModifyData;
    /**
     * Constructor method for CardSearchAndModify
     * @uses CardSearchAndModify::setCARD_OBJID()
     * @uses CardSearchAndModify::setCardModifyData()
     * @param string $cARD_OBJID
     * @param \StructType\CardModifyData $cardModifyData
     */
    public function __construct($cARD_OBJID = null, \StructType\CardModifyData $cardModifyData = null)
    {
        $this
            ->setCARD_OBJID($cARD_OBJID)
            ->setCardModifyData($cardModifyData);
    }
    /**
     * Get CARD_OBJID value
     * @return string
     */
    public function getCARD_OBJID()
    {
        return $this->{'CARD-OBJID'};
    }
    /**
     * Set CARD_OBJID value
     * @param string $cARD_OBJID
     * @return \StructType\CardSearchAndModify
     */
    public function setCARD_OBJID($cARD_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($cARD_OBJID) && !is_string($cARD_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cARD_OBJID, true), gettype($cARD_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($cARD_OBJID) && !preg_match('/([0-9])*/', $cARD_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($cARD_OBJID, true)), __LINE__);
        }
        $this->CARD_OBJID = $this->{'CARD-OBJID'} = $cARD_OBJID;
        return $this;
    }
    /**
     * Get CardModifyData value
     * @return \StructType\CardModifyData
     */
    public function getCardModifyData()
    {
        return $this->CardModifyData;
    }
    /**
     * Set CardModifyData value
     * @param \StructType\CardModifyData $cardModifyData
     * @return \StructType\CardSearchAndModify
     */
    public function setCardModifyData(\StructType\CardModifyData $cardModifyData = null)
    {
        $this->CardModifyData = $cardModifyData;
        return $this;
    }
}
