<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CardModifyData StructType
 * @subpackage Structs
 */
class CardModifyData extends AbstractStructBase
{
    /**
     * The Flags
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 18
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $Flags;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Token;
    /**
     * The ExtAddRef
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $ExtAddRef;
    /**
     * The CCType
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $CCType;
    /**
     * The ExpireDateHandle
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $ExpireDateHandle;
    /**
     * The ExpireDate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $ExpireDate;
    /**
     * The ErrorMsg
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMsg;
    /**
     * The CardTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardTypeCode;
    /**
     * The ServiceProvider
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceProvider;
    /**
     * The CardNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardNo;
    /**
     * The CardText
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $CardText;
    /**
     * Constructor method for CardModifyData
     * @uses CardModifyData::setFlags()
     * @uses CardModifyData::setToken()
     * @uses CardModifyData::setExtAddRef()
     * @uses CardModifyData::setCCType()
     * @uses CardModifyData::setExpireDateHandle()
     * @uses CardModifyData::setExpireDate()
     * @uses CardModifyData::setErrorMsg()
     * @uses CardModifyData::setCardTypeCode()
     * @uses CardModifyData::setServiceProvider()
     * @uses CardModifyData::setCardNo()
     * @uses CardModifyData::setCardText()
     * @param string $flags
     * @param string $token
     * @param string $extAddRef
     * @param string $cCType
     * @param string $expireDateHandle
     * @param string $expireDate
     * @param string $errorMsg
     * @param string $cardTypeCode
     * @param string $serviceProvider
     * @param string $cardNo
     * @param string $cardText
     */
    public function __construct($flags = null, $token = null, $extAddRef = null, $cCType = null, $expireDateHandle = null, $expireDate = null, $errorMsg = null, $cardTypeCode = null, $serviceProvider = null, $cardNo = null, $cardText = null)
    {
        $this
            ->setFlags($flags)
            ->setToken($token)
            ->setExtAddRef($extAddRef)
            ->setCCType($cCType)
            ->setExpireDateHandle($expireDateHandle)
            ->setExpireDate($expireDate)
            ->setErrorMsg($errorMsg)
            ->setCardTypeCode($cardTypeCode)
            ->setServiceProvider($serviceProvider)
            ->setCardNo($cardNo)
            ->setCardText($cardText);
    }
    /**
     * Get Flags value
     * @return string
     */
    public function getFlags()
    {
        return $this->Flags;
    }
    /**
     * Set Flags value
     * @param string $flags
     * @return \StructType\CardModifyData
     */
    public function setFlags($flags = null)
    {
        // validation for constraint: string
        if (!is_null($flags) && !is_string($flags)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flags, true), gettype($flags)), __LINE__);
        }
        // validation for constraint: maxLength(18)
        if (!is_null($flags) && mb_strlen($flags) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 18', mb_strlen($flags)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($flags) && mb_strlen($flags) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($flags)), __LINE__);
        }
        $this->Flags = $flags;
        return $this;
    }
    /**
     * Get Token value
     * @return string|null
     */
    public function getToken()
    {
        return $this->Token;
    }
    /**
     * Set Token value
     * @param string $token
     * @return \StructType\CardModifyData
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($token) && mb_strlen($token) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($token)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($token) && mb_strlen($token) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($token)), __LINE__);
        }
        $this->Token = $token;
        return $this;
    }
    /**
     * Get ExtAddRef value
     * @return string|null
     */
    public function getExtAddRef()
    {
        return $this->ExtAddRef;
    }
    /**
     * Set ExtAddRef value
     * @param string $extAddRef
     * @return \StructType\CardModifyData
     */
    public function setExtAddRef($extAddRef = null)
    {
        // validation for constraint: string
        if (!is_null($extAddRef) && !is_string($extAddRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extAddRef, true), gettype($extAddRef)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($extAddRef) && mb_strlen($extAddRef) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($extAddRef)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($extAddRef) && mb_strlen($extAddRef) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($extAddRef)), __LINE__);
        }
        $this->ExtAddRef = $extAddRef;
        return $this;
    }
    /**
     * Get CCType value
     * @return string|null
     */
    public function getCCType()
    {
        return $this->CCType;
    }
    /**
     * Set CCType value
     * @param string $cCType
     * @return \StructType\CardModifyData
     */
    public function setCCType($cCType = null)
    {
        // validation for constraint: string
        if (!is_null($cCType) && !is_string($cCType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cCType, true), gettype($cCType)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($cCType) && mb_strlen($cCType) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($cCType)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($cCType) && mb_strlen($cCType) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($cCType)), __LINE__);
        }
        $this->CCType = $cCType;
        return $this;
    }
    /**
     * Get ExpireDateHandle value
     * @return string|null
     */
    public function getExpireDateHandle()
    {
        return $this->ExpireDateHandle;
    }
    /**
     * Set ExpireDateHandle value
     * @param string $expireDateHandle
     * @return \StructType\CardModifyData
     */
    public function setExpireDateHandle($expireDateHandle = null)
    {
        // validation for constraint: string
        if (!is_null($expireDateHandle) && !is_string($expireDateHandle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDateHandle, true), gettype($expireDateHandle)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($expireDateHandle) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $expireDateHandle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($expireDateHandle, true)), __LINE__);
        }
        $this->ExpireDateHandle = $expireDateHandle;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\CardModifyData
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($expireDate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($expireDate, true)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get ErrorMsg value
     * @return string|null
     */
    public function getErrorMsg()
    {
        return $this->ErrorMsg;
    }
    /**
     * Set ErrorMsg value
     * @param string $errorMsg
     * @return \StructType\CardModifyData
     */
    public function setErrorMsg($errorMsg = null)
    {
        // validation for constraint: string
        if (!is_null($errorMsg) && !is_string($errorMsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMsg, true), gettype($errorMsg)), __LINE__);
        }
        $this->ErrorMsg = $errorMsg;
        return $this;
    }
    /**
     * Get CardTypeCode value
     * @return string|null
     */
    public function getCardTypeCode()
    {
        return $this->CardTypeCode;
    }
    /**
     * Set CardTypeCode value
     * @param string $cardTypeCode
     * @return \StructType\CardModifyData
     */
    public function setCardTypeCode($cardTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardTypeCode) && !is_string($cardTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardTypeCode, true), gettype($cardTypeCode)), __LINE__);
        }
        $this->CardTypeCode = $cardTypeCode;
        return $this;
    }
    /**
     * Get ServiceProvider value
     * @return string|null
     */
    public function getServiceProvider()
    {
        return $this->ServiceProvider;
    }
    /**
     * Set ServiceProvider value
     * @param string $serviceProvider
     * @return \StructType\CardModifyData
     */
    public function setServiceProvider($serviceProvider = null)
    {
        // validation for constraint: string
        if (!is_null($serviceProvider) && !is_string($serviceProvider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceProvider, true), gettype($serviceProvider)), __LINE__);
        }
        $this->ServiceProvider = $serviceProvider;
        return $this;
    }
    /**
     * Get CardNo value
     * @return string|null
     */
    public function getCardNo()
    {
        return $this->CardNo;
    }
    /**
     * Set CardNo value
     * @param string $cardNo
     * @return \StructType\CardModifyData
     */
    public function setCardNo($cardNo = null)
    {
        // validation for constraint: string
        if (!is_null($cardNo) && !is_string($cardNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNo, true), gettype($cardNo)), __LINE__);
        }
        $this->CardNo = $cardNo;
        return $this;
    }
    /**
     * Get CardText value
     * @return string|null
     */
    public function getCardText()
    {
        return $this->CardText;
    }
    /**
     * Set CardText value
     * @param string $cardText
     * @return \StructType\CardModifyData
     */
    public function setCardText($cardText = null)
    {
        // validation for constraint: string
        if (!is_null($cardText) && !is_string($cardText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardText, true), gettype($cardText)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($cardText) && mb_strlen($cardText) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($cardText)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($cardText) && mb_strlen($cardText) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($cardText)), __LINE__);
        }
        $this->CardText = $cardText;
        return $this;
    }
}
