<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for COMPONENT StructType
 * @subpackage Structs
 */
class COMPONENT extends AbstractStructBase
{
    /**
     * The COMPONENT_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $COMPONENT_OBJID;
    /**
     * The servicetype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $servicetype;
    /**
     * The service
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $service;
    /**
     * The descriptionlst
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $descriptionlst;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $quantity;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $amount;
    /**
     * The amountnet
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $amountnet;
    /**
     * The priceperunit
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $priceperunit;
    /**
     * The revenueaccount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $revenueaccount;
    /**
     * The revenuearea
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $revenuearea;
    /**
     * The discount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $discount;
    /**
     * Constructor method for COMPONENT
     * @uses COMPONENT::setCOMPONENT_OBJID()
     * @uses COMPONENT::setServicetype()
     * @uses COMPONENT::setService()
     * @uses COMPONENT::setDescriptionlst()
     * @uses COMPONENT::setQuantity()
     * @uses COMPONENT::setAmount()
     * @uses COMPONENT::setAmountnet()
     * @uses COMPONENT::setPriceperunit()
     * @uses COMPONENT::setRevenueaccount()
     * @uses COMPONENT::setRevenuearea()
     * @uses COMPONENT::setDiscount()
     * @param string $cOMPONENT_OBJID
     * @param string $servicetype
     * @param string $service
     * @param string $descriptionlst
     * @param string $quantity
     * @param string $amount
     * @param string $amountnet
     * @param string $priceperunit
     * @param string $revenueaccount
     * @param string $revenuearea
     * @param string $discount
     */
    public function __construct($cOMPONENT_OBJID = null, $servicetype = null, $service = null, $descriptionlst = null, $quantity = null, $amount = null, $amountnet = null, $priceperunit = null, $revenueaccount = null, $revenuearea = null, $discount = null)
    {
        $this
            ->setCOMPONENT_OBJID($cOMPONENT_OBJID)
            ->setServicetype($servicetype)
            ->setService($service)
            ->setDescriptionlst($descriptionlst)
            ->setQuantity($quantity)
            ->setAmount($amount)
            ->setAmountnet($amountnet)
            ->setPriceperunit($priceperunit)
            ->setRevenueaccount($revenueaccount)
            ->setRevenuearea($revenuearea)
            ->setDiscount($discount);
    }
    /**
     * Get COMPONENT_OBJID value
     * @return string
     */
    public function getCOMPONENT_OBJID()
    {
        return $this->{'COMPONENT-OBJID'};
    }
    /**
     * Set COMPONENT_OBJID value
     * @param string $cOMPONENT_OBJID
     * @return \StructType\COMPONENT
     */
    public function setCOMPONENT_OBJID($cOMPONENT_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($cOMPONENT_OBJID) && !is_string($cOMPONENT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cOMPONENT_OBJID, true), gettype($cOMPONENT_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($cOMPONENT_OBJID) && !preg_match('/([0-9])*/', $cOMPONENT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($cOMPONENT_OBJID, true)), __LINE__);
        }
        $this->COMPONENT_OBJID = $this->{'COMPONENT-OBJID'} = $cOMPONENT_OBJID;
        return $this;
    }
    /**
     * Get servicetype value
     * @return string
     */
    public function getServicetype()
    {
        return $this->servicetype;
    }
    /**
     * Set servicetype value
     * @param string $servicetype
     * @return \StructType\COMPONENT
     */
    public function setServicetype($servicetype = null)
    {
        // validation for constraint: string
        if (!is_null($servicetype) && !is_string($servicetype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($servicetype, true), gettype($servicetype)), __LINE__);
        }
        $this->servicetype = $servicetype;
        return $this;
    }
    /**
     * Get service value
     * @return string
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param string $service
     * @return \StructType\COMPONENT
     */
    public function setService($service = null)
    {
        // validation for constraint: string
        if (!is_null($service) && !is_string($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($service, true), gettype($service)), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Get descriptionlst value
     * @return string
     */
    public function getDescriptionlst()
    {
        return $this->descriptionlst;
    }
    /**
     * Set descriptionlst value
     * @param string $descriptionlst
     * @return \StructType\COMPONENT
     */
    public function setDescriptionlst($descriptionlst = null)
    {
        // validation for constraint: string
        if (!is_null($descriptionlst) && !is_string($descriptionlst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descriptionlst, true), gettype($descriptionlst)), __LINE__);
        }
        $this->descriptionlst = $descriptionlst;
        return $this;
    }
    /**
     * Get quantity value
     * @return string
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param string $quantity
     * @return \StructType\COMPONENT
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($quantity) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($quantity, true)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get amount value
     * @return string
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param string $amount
     * @return \StructType\COMPONENT
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($amount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($amount, true)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get amountnet value
     * @return string
     */
    public function getAmountnet()
    {
        return $this->amountnet;
    }
    /**
     * Set amountnet value
     * @param string $amountnet
     * @return \StructType\COMPONENT
     */
    public function setAmountnet($amountnet = null)
    {
        // validation for constraint: string
        if (!is_null($amountnet) && !is_string($amountnet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amountnet, true), gettype($amountnet)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($amountnet) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $amountnet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($amountnet, true)), __LINE__);
        }
        $this->amountnet = $amountnet;
        return $this;
    }
    /**
     * Get priceperunit value
     * @return string
     */
    public function getPriceperunit()
    {
        return $this->priceperunit;
    }
    /**
     * Set priceperunit value
     * @param string $priceperunit
     * @return \StructType\COMPONENT
     */
    public function setPriceperunit($priceperunit = null)
    {
        // validation for constraint: string
        if (!is_null($priceperunit) && !is_string($priceperunit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceperunit, true), gettype($priceperunit)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($priceperunit) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $priceperunit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($priceperunit, true)), __LINE__);
        }
        $this->priceperunit = $priceperunit;
        return $this;
    }
    /**
     * Get revenueaccount value
     * @return string
     */
    public function getRevenueaccount()
    {
        return $this->revenueaccount;
    }
    /**
     * Set revenueaccount value
     * @param string $revenueaccount
     * @return \StructType\COMPONENT
     */
    public function setRevenueaccount($revenueaccount = null)
    {
        // validation for constraint: string
        if (!is_null($revenueaccount) && !is_string($revenueaccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($revenueaccount, true), gettype($revenueaccount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($revenueaccount) && !preg_match('/([-+]){0,1}([0-9])*/', $revenueaccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($revenueaccount, true)), __LINE__);
        }
        $this->revenueaccount = $revenueaccount;
        return $this;
    }
    /**
     * Get revenuearea value
     * @return string
     */
    public function getRevenuearea()
    {
        return $this->revenuearea;
    }
    /**
     * Set revenuearea value
     * @param string $revenuearea
     * @return \StructType\COMPONENT
     */
    public function setRevenuearea($revenuearea = null)
    {
        // validation for constraint: string
        if (!is_null($revenuearea) && !is_string($revenuearea)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($revenuearea, true), gettype($revenuearea)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($revenuearea) && !preg_match('/([-+]){0,1}([0-9])*/', $revenuearea)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($revenuearea, true)), __LINE__);
        }
        $this->revenuearea = $revenuearea;
        return $this;
    }
    /**
     * Get discount value
     * @return string
     */
    public function getDiscount()
    {
        return $this->discount;
    }
    /**
     * Set discount value
     * @param string $discount
     * @return \StructType\COMPONENT
     */
    public function setDiscount($discount = null)
    {
        // validation for constraint: string
        if (!is_null($discount) && !is_string($discount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discount, true), gettype($discount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($discount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $discount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($discount, true)), __LINE__);
        }
        $this->discount = $discount;
        return $this;
    }
}
