<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CITYLEDGER-APPLY StructType
 * @subpackage Structs
 */
class CITYLEDGER_APPLY extends AbstractStructBase
{
    /**
     * The CITYLEDGER_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $CITYLEDGER_OBJID;
    /**
     * The PAYMENT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PAYMENT_1
     */
    public $PAYMENT;
    /**
     * Constructor method for CITYLEDGER-APPLY
     * @uses CITYLEDGER_APPLY::setCITYLEDGER_OBJID()
     * @uses CITYLEDGER_APPLY::setPAYMENT()
     * @param string $cITYLEDGER_OBJID
     * @param \StructType\PAYMENT_1 $pAYMENT
     */
    public function __construct($cITYLEDGER_OBJID = null, \StructType\PAYMENT_1 $pAYMENT = null)
    {
        $this
            ->setCITYLEDGER_OBJID($cITYLEDGER_OBJID)
            ->setPAYMENT($pAYMENT);
    }
    /**
     * Get CITYLEDGER_OBJID value
     * @return string
     */
    public function getCITYLEDGER_OBJID()
    {
        return $this->{'CITYLEDGER-OBJID'};
    }
    /**
     * Set CITYLEDGER_OBJID value
     * @param string $cITYLEDGER_OBJID
     * @return \StructType\CITYLEDGER_APPLY
     */
    public function setCITYLEDGER_OBJID($cITYLEDGER_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($cITYLEDGER_OBJID) && !is_string($cITYLEDGER_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cITYLEDGER_OBJID, true), gettype($cITYLEDGER_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($cITYLEDGER_OBJID) && !preg_match('/([0-9])*/', $cITYLEDGER_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($cITYLEDGER_OBJID, true)), __LINE__);
        }
        $this->CITYLEDGER_OBJID = $this->{'CITYLEDGER-OBJID'} = $cITYLEDGER_OBJID;
        return $this;
    }
    /**
     * Get PAYMENT value
     * @return \StructType\PAYMENT_1|null
     */
    public function getPAYMENT()
    {
        return $this->PAYMENT;
    }
    /**
     * Set PAYMENT value
     * @param \StructType\PAYMENT_1 $pAYMENT
     * @return \StructType\CITYLEDGER_APPLY
     */
    public function setPAYMENT(\StructType\PAYMENT_1 $pAYMENT = null)
    {
        $this->PAYMENT = $pAYMENT;
        return $this;
    }
}
