<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CITYLEDGER-ACCOUNT-SEARCH StructType
 * @subpackage Structs
 */
class CITYLEDGER_ACCOUNT_SEARCH extends AbstractStructBase
{
    /**
     * The name1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name1;
    /**
     * The identnumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $identnumber;
    /**
     * The admcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $admcode;
    /**
     * The openops
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $openops;
    /**
     * The accountno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $accountno;
    /**
     * The invoiceno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9])*
     * @var string
     */
    public $invoiceno;
    /**
     * The invoicesumamount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $invoicesumamount;
    /**
     * The invoicedatefrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $invoicedatefrom;
    /**
     * The invoicedateto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $invoicedateto;
    /**
     * The debtorno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $debtorno;
    /**
     * The voucherno
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $voucherno;
    /**
     * The suppresszerobalances
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $suppresszerobalances;
    /**
     * The reminderlevel
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $reminderlevel;
    /**
     * Constructor method for CITYLEDGER-ACCOUNT-SEARCH
     * @uses CITYLEDGER_ACCOUNT_SEARCH::setName1()
     * @uses CITYLEDGER_ACCOUNT_SEARCH::setIdentnumber()
     * @uses CITYLEDGER_ACCOUNT_SEARCH::setAdmcode()
     * @uses CITYLEDGER_ACCOUNT_SEARCH::setOpenops()
     * @uses CITYLEDGER_ACCOUNT_SEARCH::setAccountno()
     * @uses CITYLEDGER_ACCOUNT_SEARCH::setInvoiceno()
     * @uses CITYLEDGER_ACCOUNT_SEARCH::setInvoicesumamount()
     * @uses CITYLEDGER_ACCOUNT_SEARCH::setInvoicedatefrom()
     * @uses CITYLEDGER_ACCOUNT_SEARCH::setInvoicedateto()
     * @uses CITYLEDGER_ACCOUNT_SEARCH::setDebtorno()
     * @uses CITYLEDGER_ACCOUNT_SEARCH::setVoucherno()
     * @uses CITYLEDGER_ACCOUNT_SEARCH::setSuppresszerobalances()
     * @uses CITYLEDGER_ACCOUNT_SEARCH::setReminderlevel()
     * @param string $name1
     * @param string $identnumber
     * @param string $admcode
     * @param string $openops
     * @param string $accountno
     * @param string $invoiceno
     * @param string $invoicesumamount
     * @param string $invoicedatefrom
     * @param string $invoicedateto
     * @param string $debtorno
     * @param string $voucherno
     * @param string $suppresszerobalances
     * @param string $reminderlevel
     */
    public function __construct($name1 = null, $identnumber = null, $admcode = null, $openops = null, $accountno = null, $invoiceno = null, $invoicesumamount = null, $invoicedatefrom = null, $invoicedateto = null, $debtorno = null, $voucherno = null, $suppresszerobalances = null, $reminderlevel = null)
    {
        $this
            ->setName1($name1)
            ->setIdentnumber($identnumber)
            ->setAdmcode($admcode)
            ->setOpenops($openops)
            ->setAccountno($accountno)
            ->setInvoiceno($invoiceno)
            ->setInvoicesumamount($invoicesumamount)
            ->setInvoicedatefrom($invoicedatefrom)
            ->setInvoicedateto($invoicedateto)
            ->setDebtorno($debtorno)
            ->setVoucherno($voucherno)
            ->setSuppresszerobalances($suppresszerobalances)
            ->setReminderlevel($reminderlevel);
    }
    /**
     * Get name1 value
     * @return string|null
     */
    public function getName1()
    {
        return $this->name1;
    }
    /**
     * Set name1 value
     * @param string $name1
     * @return \StructType\CITYLEDGER_ACCOUNT_SEARCH
     */
    public function setName1($name1 = null)
    {
        // validation for constraint: string
        if (!is_null($name1) && !is_string($name1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name1, true), gettype($name1)), __LINE__);
        }
        $this->name1 = $name1;
        return $this;
    }
    /**
     * Get identnumber value
     * @return string|null
     */
    public function getIdentnumber()
    {
        return $this->identnumber;
    }
    /**
     * Set identnumber value
     * @param string $identnumber
     * @return \StructType\CITYLEDGER_ACCOUNT_SEARCH
     */
    public function setIdentnumber($identnumber = null)
    {
        // validation for constraint: string
        if (!is_null($identnumber) && !is_string($identnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identnumber, true), gettype($identnumber)), __LINE__);
        }
        $this->identnumber = $identnumber;
        return $this;
    }
    /**
     * Get admcode value
     * @return string|null
     */
    public function getAdmcode()
    {
        return $this->admcode;
    }
    /**
     * Set admcode value
     * @param string $admcode
     * @return \StructType\CITYLEDGER_ACCOUNT_SEARCH
     */
    public function setAdmcode($admcode = null)
    {
        // validation for constraint: string
        if (!is_null($admcode) && !is_string($admcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($admcode, true), gettype($admcode)), __LINE__);
        }
        $this->admcode = $admcode;
        return $this;
    }
    /**
     * Get openops value
     * @return string|null
     */
    public function getOpenops()
    {
        return $this->openops;
    }
    /**
     * Set openops value
     * @param string $openops
     * @return \StructType\CITYLEDGER_ACCOUNT_SEARCH
     */
    public function setOpenops($openops = null)
    {
        // validation for constraint: string
        if (!is_null($openops) && !is_string($openops)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($openops, true), gettype($openops)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($openops) && !preg_match('/([-+]){0,1}([0-9])*/', $openops)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($openops, true)), __LINE__);
        }
        $this->openops = $openops;
        return $this;
    }
    /**
     * Get accountno value
     * @return string|null
     */
    public function getAccountno()
    {
        return $this->accountno;
    }
    /**
     * Set accountno value
     * @param string $accountno
     * @return \StructType\CITYLEDGER_ACCOUNT_SEARCH
     */
    public function setAccountno($accountno = null)
    {
        // validation for constraint: string
        if (!is_null($accountno) && !is_string($accountno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountno, true), gettype($accountno)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($accountno) && !preg_match('/([-+]){0,1}([0-9])*/', $accountno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($accountno, true)), __LINE__);
        }
        $this->accountno = $accountno;
        return $this;
    }
    /**
     * Get invoiceno value
     * @return string|null
     */
    public function getInvoiceno()
    {
        return $this->invoiceno;
    }
    /**
     * Set invoiceno value
     * @param string $invoiceno
     * @return \StructType\CITYLEDGER_ACCOUNT_SEARCH
     */
    public function setInvoiceno($invoiceno = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceno) && !is_string($invoiceno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceno, true), gettype($invoiceno)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($invoiceno) && !preg_match('/([0-9])*/', $invoiceno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($invoiceno, true)), __LINE__);
        }
        $this->invoiceno = $invoiceno;
        return $this;
    }
    /**
     * Get invoicesumamount value
     * @return string|null
     */
    public function getInvoicesumamount()
    {
        return $this->invoicesumamount;
    }
    /**
     * Set invoicesumamount value
     * @param string $invoicesumamount
     * @return \StructType\CITYLEDGER_ACCOUNT_SEARCH
     */
    public function setInvoicesumamount($invoicesumamount = null)
    {
        // validation for constraint: string
        if (!is_null($invoicesumamount) && !is_string($invoicesumamount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoicesumamount, true), gettype($invoicesumamount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($invoicesumamount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $invoicesumamount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($invoicesumamount, true)), __LINE__);
        }
        $this->invoicesumamount = $invoicesumamount;
        return $this;
    }
    /**
     * Get invoicedatefrom value
     * @return string|null
     */
    public function getInvoicedatefrom()
    {
        return $this->invoicedatefrom;
    }
    /**
     * Set invoicedatefrom value
     * @param string $invoicedatefrom
     * @return \StructType\CITYLEDGER_ACCOUNT_SEARCH
     */
    public function setInvoicedatefrom($invoicedatefrom = null)
    {
        // validation for constraint: string
        if (!is_null($invoicedatefrom) && !is_string($invoicedatefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoicedatefrom, true), gettype($invoicedatefrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($invoicedatefrom) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $invoicedatefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($invoicedatefrom, true)), __LINE__);
        }
        $this->invoicedatefrom = $invoicedatefrom;
        return $this;
    }
    /**
     * Get invoicedateto value
     * @return string|null
     */
    public function getInvoicedateto()
    {
        return $this->invoicedateto;
    }
    /**
     * Set invoicedateto value
     * @param string $invoicedateto
     * @return \StructType\CITYLEDGER_ACCOUNT_SEARCH
     */
    public function setInvoicedateto($invoicedateto = null)
    {
        // validation for constraint: string
        if (!is_null($invoicedateto) && !is_string($invoicedateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoicedateto, true), gettype($invoicedateto)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($invoicedateto) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $invoicedateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($invoicedateto, true)), __LINE__);
        }
        $this->invoicedateto = $invoicedateto;
        return $this;
    }
    /**
     * Get debtorno value
     * @return string|null
     */
    public function getDebtorno()
    {
        return $this->debtorno;
    }
    /**
     * Set debtorno value
     * @param string $debtorno
     * @return \StructType\CITYLEDGER_ACCOUNT_SEARCH
     */
    public function setDebtorno($debtorno = null)
    {
        // validation for constraint: string
        if (!is_null($debtorno) && !is_string($debtorno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($debtorno, true), gettype($debtorno)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($debtorno) && !preg_match('/([-+]){0,1}([0-9])*/', $debtorno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($debtorno, true)), __LINE__);
        }
        $this->debtorno = $debtorno;
        return $this;
    }
    /**
     * Get voucherno value
     * @return string|null
     */
    public function getVoucherno()
    {
        return $this->voucherno;
    }
    /**
     * Set voucherno value
     * @param string $voucherno
     * @return \StructType\CITYLEDGER_ACCOUNT_SEARCH
     */
    public function setVoucherno($voucherno = null)
    {
        // validation for constraint: string
        if (!is_null($voucherno) && !is_string($voucherno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherno, true), gettype($voucherno)), __LINE__);
        }
        $this->voucherno = $voucherno;
        return $this;
    }
    /**
     * Get suppresszerobalances value
     * @return string|null
     */
    public function getSuppresszerobalances()
    {
        return $this->suppresszerobalances;
    }
    /**
     * Set suppresszerobalances value
     * @param string $suppresszerobalances
     * @return \StructType\CITYLEDGER_ACCOUNT_SEARCH
     */
    public function setSuppresszerobalances($suppresszerobalances = null)
    {
        // validation for constraint: string
        if (!is_null($suppresszerobalances) && !is_string($suppresszerobalances)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($suppresszerobalances, true), gettype($suppresszerobalances)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($suppresszerobalances) && !preg_match('/([-+]){0,1}([0-9])*/', $suppresszerobalances)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($suppresszerobalances, true)), __LINE__);
        }
        $this->suppresszerobalances = $suppresszerobalances;
        return $this;
    }
    /**
     * Get reminderlevel value
     * @return string|null
     */
    public function getReminderlevel()
    {
        return $this->reminderlevel;
    }
    /**
     * Set reminderlevel value
     * @param string $reminderlevel
     * @return \StructType\CITYLEDGER_ACCOUNT_SEARCH
     */
    public function setReminderlevel($reminderlevel = null)
    {
        // validation for constraint: string
        if (!is_null($reminderlevel) && !is_string($reminderlevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reminderlevel, true), gettype($reminderlevel)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($reminderlevel) && !preg_match('/([-+]){0,1}([0-9])*/', $reminderlevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($reminderlevel, true)), __LINE__);
        }
        $this->reminderlevel = $reminderlevel;
        return $this;
    }
}
