<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CITYLEDGER-ACCOUNT StructType
 * @subpackage Structs
 */
class CITYLEDGER_ACCOUNT extends AbstractStructBase
{
    /**
     * The CITYLEDGER_ACCOUNT_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $CITYLEDGER_ACCOUNT_OBJID;
    /**
     * The cityledgerbalance
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $cityledgerbalance;
    /**
     * The depositbalance
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $depositbalance;
    /**
     * The balance
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $balance;
    /**
     * The CITYLEDGERS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\CITYLEDGERS
     */
    public $CITYLEDGERS;
    /**
     * The GUEST
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GUEST[]
     */
    public $GUEST;
    /**
     * Constructor method for CITYLEDGER-ACCOUNT
     * @uses CITYLEDGER_ACCOUNT::setCITYLEDGER_ACCOUNT_OBJID()
     * @uses CITYLEDGER_ACCOUNT::setCityledgerbalance()
     * @uses CITYLEDGER_ACCOUNT::setDepositbalance()
     * @uses CITYLEDGER_ACCOUNT::setBalance()
     * @uses CITYLEDGER_ACCOUNT::setCITYLEDGERS()
     * @uses CITYLEDGER_ACCOUNT::setGUEST()
     * @param string $cITYLEDGER_ACCOUNT_OBJID
     * @param string $cityledgerbalance
     * @param string $depositbalance
     * @param string $balance
     * @param \StructType\CITYLEDGERS $cITYLEDGERS
     * @param \StructType\GUEST[] $gUEST
     */
    public function __construct($cITYLEDGER_ACCOUNT_OBJID = null, $cityledgerbalance = null, $depositbalance = null, $balance = null, \StructType\CITYLEDGERS $cITYLEDGERS = null, array $gUEST = array())
    {
        $this
            ->setCITYLEDGER_ACCOUNT_OBJID($cITYLEDGER_ACCOUNT_OBJID)
            ->setCityledgerbalance($cityledgerbalance)
            ->setDepositbalance($depositbalance)
            ->setBalance($balance)
            ->setCITYLEDGERS($cITYLEDGERS)
            ->setGUEST($gUEST);
    }
    /**
     * Get CITYLEDGER_ACCOUNT_OBJID value
     * @return string
     */
    public function getCITYLEDGER_ACCOUNT_OBJID()
    {
        return $this->{'CITYLEDGER-ACCOUNT-OBJID'};
    }
    /**
     * Set CITYLEDGER_ACCOUNT_OBJID value
     * @param string $cITYLEDGER_ACCOUNT_OBJID
     * @return \StructType\CITYLEDGER_ACCOUNT
     */
    public function setCITYLEDGER_ACCOUNT_OBJID($cITYLEDGER_ACCOUNT_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($cITYLEDGER_ACCOUNT_OBJID) && !is_string($cITYLEDGER_ACCOUNT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cITYLEDGER_ACCOUNT_OBJID, true), gettype($cITYLEDGER_ACCOUNT_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($cITYLEDGER_ACCOUNT_OBJID) && !preg_match('/([0-9])*/', $cITYLEDGER_ACCOUNT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($cITYLEDGER_ACCOUNT_OBJID, true)), __LINE__);
        }
        $this->CITYLEDGER_ACCOUNT_OBJID = $this->{'CITYLEDGER-ACCOUNT-OBJID'} = $cITYLEDGER_ACCOUNT_OBJID;
        return $this;
    }
    /**
     * Get cityledgerbalance value
     * @return string
     */
    public function getCityledgerbalance()
    {
        return $this->cityledgerbalance;
    }
    /**
     * Set cityledgerbalance value
     * @param string $cityledgerbalance
     * @return \StructType\CITYLEDGER_ACCOUNT
     */
    public function setCityledgerbalance($cityledgerbalance = null)
    {
        // validation for constraint: string
        if (!is_null($cityledgerbalance) && !is_string($cityledgerbalance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityledgerbalance, true), gettype($cityledgerbalance)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($cityledgerbalance) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $cityledgerbalance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($cityledgerbalance, true)), __LINE__);
        }
        $this->cityledgerbalance = $cityledgerbalance;
        return $this;
    }
    /**
     * Get depositbalance value
     * @return string
     */
    public function getDepositbalance()
    {
        return $this->depositbalance;
    }
    /**
     * Set depositbalance value
     * @param string $depositbalance
     * @return \StructType\CITYLEDGER_ACCOUNT
     */
    public function setDepositbalance($depositbalance = null)
    {
        // validation for constraint: string
        if (!is_null($depositbalance) && !is_string($depositbalance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositbalance, true), gettype($depositbalance)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($depositbalance) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $depositbalance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($depositbalance, true)), __LINE__);
        }
        $this->depositbalance = $depositbalance;
        return $this;
    }
    /**
     * Get balance value
     * @return string
     */
    public function getBalance()
    {
        return $this->balance;
    }
    /**
     * Set balance value
     * @param string $balance
     * @return \StructType\CITYLEDGER_ACCOUNT
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: string
        if (!is_null($balance) && !is_string($balance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($balance, true), gettype($balance)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($balance) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $balance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($balance, true)), __LINE__);
        }
        $this->balance = $balance;
        return $this;
    }
    /**
     * Get CITYLEDGERS value
     * @return \StructType\CITYLEDGERS
     */
    public function getCITYLEDGERS()
    {
        return $this->CITYLEDGERS;
    }
    /**
     * Set CITYLEDGERS value
     * @param \StructType\CITYLEDGERS $cITYLEDGERS
     * @return \StructType\CITYLEDGER_ACCOUNT
     */
    public function setCITYLEDGERS(\StructType\CITYLEDGERS $cITYLEDGERS = null)
    {
        $this->CITYLEDGERS = $cITYLEDGERS;
        return $this;
    }
    /**
     * Get GUEST value
     * @return \StructType\GUEST[]|null
     */
    public function getGUEST()
    {
        return $this->GUEST;
    }
    /**
     * This method is responsible for validating the values passed to the setGUEST method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGUEST method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGUESTForArrayConstraintsFromSetGUEST(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cITYLEDGER_ACCOUNTGUESTItem) {
            // validation for constraint: itemType
            if (!$cITYLEDGER_ACCOUNTGUESTItem instanceof \StructType\GUEST) {
                $invalidValues[] = is_object($cITYLEDGER_ACCOUNTGUESTItem) ? get_class($cITYLEDGER_ACCOUNTGUESTItem) : sprintf('%s(%s)', gettype($cITYLEDGER_ACCOUNTGUESTItem), var_export($cITYLEDGER_ACCOUNTGUESTItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GUEST property can only contain items of type \StructType\GUEST, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GUEST value
     * @throws \InvalidArgumentException
     * @param \StructType\GUEST[] $gUEST
     * @return \StructType\CITYLEDGER_ACCOUNT
     */
    public function setGUEST(array $gUEST = array())
    {
        // validation for constraint: array
        if ('' !== ($gUESTArrayErrorMessage = self::validateGUESTForArrayConstraintsFromSetGUEST($gUEST))) {
            throw new \InvalidArgumentException($gUESTArrayErrorMessage, __LINE__);
        }
        $this->GUEST = $gUEST;
        return $this;
    }
    /**
     * Add item to GUEST value
     * @throws \InvalidArgumentException
     * @param \StructType\GUEST $item
     * @return \StructType\CITYLEDGER_ACCOUNT
     */
    public function addToGUEST(\StructType\GUEST $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GUEST) {
            throw new \InvalidArgumentException(sprintf('The GUEST property can only contain items of type \StructType\GUEST, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GUEST[] = $item;
        return $this;
    }
}
