<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CBModuleMasterFileSearch StructType
 * @subpackage Structs
 */
class CBModuleMasterFileSearch extends AbstractStructBase
{
    /**
     * The hotel
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $hotel;
    /**
     * The cbmoduleid
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 8
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $cbmoduleid;
    /**
     * Constructor method for CBModuleMasterFileSearch
     * @uses CBModuleMasterFileSearch::setHotel()
     * @uses CBModuleMasterFileSearch::setCbmoduleid()
     * @param string $hotel
     * @param string $cbmoduleid
     */
    public function __construct($hotel = null, $cbmoduleid = null)
    {
        $this
            ->setHotel($hotel)
            ->setCbmoduleid($cbmoduleid);
    }
    /**
     * Get hotel value
     * @return string
     */
    public function getHotel()
    {
        return $this->hotel;
    }
    /**
     * Set hotel value
     * @param string $hotel
     * @return \StructType\CBModuleMasterFileSearch
     */
    public function setHotel($hotel = null)
    {
        // validation for constraint: string
        if (!is_null($hotel) && !is_string($hotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotel, true), gettype($hotel)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($hotel) && !preg_match('/([-+]){0,1}([0-9])*/', $hotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($hotel, true)), __LINE__);
        }
        $this->hotel = $hotel;
        return $this;
    }
    /**
     * Get cbmoduleid value
     * @return string|null
     */
    public function getCbmoduleid()
    {
        return $this->cbmoduleid;
    }
    /**
     * Set cbmoduleid value
     * @param string $cbmoduleid
     * @return \StructType\CBModuleMasterFileSearch
     */
    public function setCbmoduleid($cbmoduleid = null)
    {
        // validation for constraint: string
        if (!is_null($cbmoduleid) && !is_string($cbmoduleid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cbmoduleid, true), gettype($cbmoduleid)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($cbmoduleid) && mb_strlen($cbmoduleid) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($cbmoduleid)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($cbmoduleid) && mb_strlen($cbmoduleid) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($cbmoduleid)), __LINE__);
        }
        $this->cbmoduleid = $cbmoduleid;
        return $this;
    }
}
