<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bookingdata StructType
 * @subpackage Structs
 */
class Bookingdata extends AbstractStructBase
{
    /**
     * The category
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $category;
    /**
     * The datefrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $datefrom;
    /**
     * The dateto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $dateto;
    /**
     * The noofpax
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $noofpax;
    /**
     * The noofnights
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $noofnights;
    /**
     * The room
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Room_1[]
     */
    public $room;
    /**
     * Constructor method for bookingdata
     * @uses Bookingdata::setCategory()
     * @uses Bookingdata::setDatefrom()
     * @uses Bookingdata::setDateto()
     * @uses Bookingdata::setNoofpax()
     * @uses Bookingdata::setNoofnights()
     * @uses Bookingdata::setRoom()
     * @param string $category
     * @param string $datefrom
     * @param string $dateto
     * @param string $noofpax
     * @param string $noofnights
     * @param \StructType\Room_1[] $room
     */
    public function __construct($category = null, $datefrom = null, $dateto = null, $noofpax = null, $noofnights = null, array $room = array())
    {
        $this
            ->setCategory($category)
            ->setDatefrom($datefrom)
            ->setDateto($dateto)
            ->setNoofpax($noofpax)
            ->setNoofnights($noofnights)
            ->setRoom($room);
    }
    /**
     * Get category value
     * @return string
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param string $category
     * @return \StructType\Bookingdata
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($category) && mb_strlen($category) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($category)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($category) && mb_strlen($category) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($category)), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Get datefrom value
     * @return string
     */
    public function getDatefrom()
    {
        return $this->datefrom;
    }
    /**
     * Set datefrom value
     * @param string $datefrom
     * @return \StructType\Bookingdata
     */
    public function setDatefrom($datefrom = null)
    {
        // validation for constraint: string
        if (!is_null($datefrom) && !is_string($datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datefrom, true), gettype($datefrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($datefrom) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($datefrom, true)), __LINE__);
        }
        $this->datefrom = $datefrom;
        return $this;
    }
    /**
     * Get dateto value
     * @return string
     */
    public function getDateto()
    {
        return $this->dateto;
    }
    /**
     * Set dateto value
     * @param string $dateto
     * @return \StructType\Bookingdata
     */
    public function setDateto($dateto = null)
    {
        // validation for constraint: string
        if (!is_null($dateto) && !is_string($dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateto, true), gettype($dateto)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($dateto) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($dateto, true)), __LINE__);
        }
        $this->dateto = $dateto;
        return $this;
    }
    /**
     * Get noofpax value
     * @return string
     */
    public function getNoofpax()
    {
        return $this->noofpax;
    }
    /**
     * Set noofpax value
     * @param string $noofpax
     * @return \StructType\Bookingdata
     */
    public function setNoofpax($noofpax = null)
    {
        // validation for constraint: string
        if (!is_null($noofpax) && !is_string($noofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noofpax, true), gettype($noofpax)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($noofpax) && !preg_match('/([-+]){0,1}([0-9])*/', $noofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($noofpax, true)), __LINE__);
        }
        $this->noofpax = $noofpax;
        return $this;
    }
    /**
     * Get noofnights value
     * @return string
     */
    public function getNoofnights()
    {
        return $this->noofnights;
    }
    /**
     * Set noofnights value
     * @param string $noofnights
     * @return \StructType\Bookingdata
     */
    public function setNoofnights($noofnights = null)
    {
        // validation for constraint: string
        if (!is_null($noofnights) && !is_string($noofnights)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noofnights, true), gettype($noofnights)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($noofnights) && !preg_match('/([-+]){0,1}([0-9])*/', $noofnights)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($noofnights, true)), __LINE__);
        }
        $this->noofnights = $noofnights;
        return $this;
    }
    /**
     * Get room value
     * @return \StructType\Room_1[]|null
     */
    public function getRoom()
    {
        return $this->room;
    }
    /**
     * This method is responsible for validating the values passed to the setRoom method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoom method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomForArrayConstraintsFromSetRoom(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bookingdataRoomItem) {
            // validation for constraint: itemType
            if (!$bookingdataRoomItem instanceof \StructType\Room_1) {
                $invalidValues[] = is_object($bookingdataRoomItem) ? get_class($bookingdataRoomItem) : sprintf('%s(%s)', gettype($bookingdataRoomItem), var_export($bookingdataRoomItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The room property can only contain items of type \StructType\Room_1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set room value
     * @throws \InvalidArgumentException
     * @param \StructType\Room_1[] $room
     * @return \StructType\Bookingdata
     */
    public function setRoom(array $room = array())
    {
        // validation for constraint: array
        if ('' !== ($roomArrayErrorMessage = self::validateRoomForArrayConstraintsFromSetRoom($room))) {
            throw new \InvalidArgumentException($roomArrayErrorMessage, __LINE__);
        }
        $this->room = $room;
        return $this;
    }
    /**
     * Add item to room value
     * @throws \InvalidArgumentException
     * @param \StructType\Room_1 $item
     * @return \StructType\Bookingdata
     */
    public function addToRoom(\StructType\Room_1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Room_1) {
            throw new \InvalidArgumentException(sprintf('The room property can only contain items of type \StructType\Room_1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->room[] = $item;
        return $this;
    }
}
