<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Authentication StructType
 * @subpackage Structs
 */
class Authentication extends AbstractStructBase
{
    /**
     * The SecurityID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SecurityID;
    /**
     * The ValidFromUTC
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ValidFromUTC;
    /**
     * The ValidUntilUTC
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ValidUntilUTC;
    /**
     * The DurationInSec
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $DurationInSec;
    /**
     * Constructor method for Authentication
     * @uses Authentication::setSecurityID()
     * @uses Authentication::setValidFromUTC()
     * @uses Authentication::setValidUntilUTC()
     * @uses Authentication::setDurationInSec()
     * @param string $securityID
     * @param string $validFromUTC
     * @param string $validUntilUTC
     * @param string $durationInSec
     */
    public function __construct($securityID = null, $validFromUTC = null, $validUntilUTC = null, $durationInSec = null)
    {
        $this
            ->setSecurityID($securityID)
            ->setValidFromUTC($validFromUTC)
            ->setValidUntilUTC($validUntilUTC)
            ->setDurationInSec($durationInSec);
    }
    /**
     * Get SecurityID value
     * @return string
     */
    public function getSecurityID()
    {
        return $this->SecurityID;
    }
    /**
     * Set SecurityID value
     * @param string $securityID
     * @return \StructType\Authentication
     */
    public function setSecurityID($securityID = null)
    {
        // validation for constraint: string
        if (!is_null($securityID) && !is_string($securityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityID, true), gettype($securityID)), __LINE__);
        }
        $this->SecurityID = $securityID;
        return $this;
    }
    /**
     * Get ValidFromUTC value
     * @return string
     */
    public function getValidFromUTC()
    {
        return $this->ValidFromUTC;
    }
    /**
     * Set ValidFromUTC value
     * @param string $validFromUTC
     * @return \StructType\Authentication
     */
    public function setValidFromUTC($validFromUTC = null)
    {
        // validation for constraint: string
        if (!is_null($validFromUTC) && !is_string($validFromUTC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validFromUTC, true), gettype($validFromUTC)), __LINE__);
        }
        $this->ValidFromUTC = $validFromUTC;
        return $this;
    }
    /**
     * Get ValidUntilUTC value
     * @return string
     */
    public function getValidUntilUTC()
    {
        return $this->ValidUntilUTC;
    }
    /**
     * Set ValidUntilUTC value
     * @param string $validUntilUTC
     * @return \StructType\Authentication
     */
    public function setValidUntilUTC($validUntilUTC = null)
    {
        // validation for constraint: string
        if (!is_null($validUntilUTC) && !is_string($validUntilUTC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validUntilUTC, true), gettype($validUntilUTC)), __LINE__);
        }
        $this->ValidUntilUTC = $validUntilUTC;
        return $this;
    }
    /**
     * Get DurationInSec value
     * @return string
     */
    public function getDurationInSec()
    {
        return $this->DurationInSec;
    }
    /**
     * Set DurationInSec value
     * @param string $durationInSec
     * @return \StructType\Authentication
     */
    public function setDurationInSec($durationInSec = null)
    {
        // validation for constraint: string
        if (!is_null($durationInSec) && !is_string($durationInSec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($durationInSec, true), gettype($durationInSec)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($durationInSec) && !preg_match('/([-+]){0,1}([0-9])*/', $durationInSec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($durationInSec, true)), __LINE__);
        }
        $this->DurationInSec = $durationInSec;
        return $this;
    }
}
