<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthenticateResponse StructType
 * @subpackage Structs
 */
class AuthenticateResponse extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Authentication[]
     */
    public $Authentication;
    /**
     * Constructor method for AuthenticateResponse
     * @uses AuthenticateResponse::setResult()
     * @uses AuthenticateResponse::setTransactionID()
     * @uses AuthenticateResponse::setAuthentication()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\Authentication[] $authentication
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $authentication = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setAuthentication($authentication);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\AuthenticateResponse
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\AuthenticateResponse
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication[]|null
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * This method is responsible for validating the values passed to the setAuthentication method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAuthentication method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAuthenticationForArrayConstraintsFromSetAuthentication(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $authenticateResponseAuthenticationItem) {
            // validation for constraint: itemType
            if (!$authenticateResponseAuthenticationItem instanceof \StructType\Authentication) {
                $invalidValues[] = is_object($authenticateResponseAuthenticationItem) ? get_class($authenticateResponseAuthenticationItem) : sprintf('%s(%s)', gettype($authenticateResponseAuthenticationItem), var_export($authenticateResponseAuthenticationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Authentication property can only contain items of type \StructType\Authentication, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Authentication value
     * @throws \InvalidArgumentException
     * @param \StructType\Authentication[] $authentication
     * @return \StructType\AuthenticateResponse
     */
    public function setAuthentication(array $authentication = array())
    {
        // validation for constraint: array
        if ('' !== ($authenticationArrayErrorMessage = self::validateAuthenticationForArrayConstraintsFromSetAuthentication($authentication))) {
            throw new \InvalidArgumentException($authenticationArrayErrorMessage, __LINE__);
        }
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Add item to Authentication value
     * @throws \InvalidArgumentException
     * @param \StructType\Authentication $item
     * @return \StructType\AuthenticateResponse
     */
    public function addToAuthentication(\StructType\Authentication $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Authentication) {
            throw new \InvalidArgumentException(sprintf('The Authentication property can only contain items of type \StructType\Authentication, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Authentication[] = $item;
        return $this;
    }
}
