<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthCommit StructType
 * @subpackage Structs
 */
class AuthCommit extends AbstractStructBase
{
    /**
     * The cardInfoRefID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $cardInfoRefID;
    /**
     * The serviceProvider
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $serviceProvider;
    /**
     * The returnCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $returnCode;
    /**
     * The transactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $transactionID;
    /**
     * The authorizationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $authorizationCode;
    /**
     * The cardTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $cardTypeCode;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $amount;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $currency;
    /**
     * The cardNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $cardNumber;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The receipt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $receipt;
    /**
     * The receiptCardHolder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $receiptCardHolder;
    /**
     * The emvTerminal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $emvTerminal;
    /**
     * The token
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $token;
    /**
     * The tokenValidUntil
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $tokenValidUntil;
    /**
     * Constructor method for AuthCommit
     * @uses AuthCommit::setCardInfoRefID()
     * @uses AuthCommit::setServiceProvider()
     * @uses AuthCommit::setReturnCode()
     * @uses AuthCommit::setTransactionID()
     * @uses AuthCommit::setAuthorizationCode()
     * @uses AuthCommit::setCardTypeCode()
     * @uses AuthCommit::setAmount()
     * @uses AuthCommit::setCurrency()
     * @uses AuthCommit::setCardNumber()
     * @uses AuthCommit::setDescription()
     * @uses AuthCommit::setReceipt()
     * @uses AuthCommit::setReceiptCardHolder()
     * @uses AuthCommit::setEmvTerminal()
     * @uses AuthCommit::setToken()
     * @uses AuthCommit::setTokenValidUntil()
     * @param string $cardInfoRefID
     * @param string $serviceProvider
     * @param string $returnCode
     * @param string $transactionID
     * @param string $authorizationCode
     * @param string $cardTypeCode
     * @param string $amount
     * @param string $currency
     * @param string $cardNumber
     * @param string $description
     * @param string $receipt
     * @param string $receiptCardHolder
     * @param string $emvTerminal
     * @param string $token
     * @param string $tokenValidUntil
     */
    public function __construct($cardInfoRefID = null, $serviceProvider = null, $returnCode = null, $transactionID = null, $authorizationCode = null, $cardTypeCode = null, $amount = null, $currency = null, $cardNumber = null, $description = null, $receipt = null, $receiptCardHolder = null, $emvTerminal = null, $token = null, $tokenValidUntil = null)
    {
        $this
            ->setCardInfoRefID($cardInfoRefID)
            ->setServiceProvider($serviceProvider)
            ->setReturnCode($returnCode)
            ->setTransactionID($transactionID)
            ->setAuthorizationCode($authorizationCode)
            ->setCardTypeCode($cardTypeCode)
            ->setAmount($amount)
            ->setCurrency($currency)
            ->setCardNumber($cardNumber)
            ->setDescription($description)
            ->setReceipt($receipt)
            ->setReceiptCardHolder($receiptCardHolder)
            ->setEmvTerminal($emvTerminal)
            ->setToken($token)
            ->setTokenValidUntil($tokenValidUntil);
    }
    /**
     * Get cardInfoRefID value
     * @return string
     */
    public function getCardInfoRefID()
    {
        return $this->cardInfoRefID;
    }
    /**
     * Set cardInfoRefID value
     * @param string $cardInfoRefID
     * @return \StructType\AuthCommit
     */
    public function setCardInfoRefID($cardInfoRefID = null)
    {
        // validation for constraint: string
        if (!is_null($cardInfoRefID) && !is_string($cardInfoRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardInfoRefID, true), gettype($cardInfoRefID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($cardInfoRefID) && !preg_match('/([0-9])*/', $cardInfoRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($cardInfoRefID, true)), __LINE__);
        }
        $this->cardInfoRefID = $cardInfoRefID;
        return $this;
    }
    /**
     * Get serviceProvider value
     * @return string
     */
    public function getServiceProvider()
    {
        return $this->serviceProvider;
    }
    /**
     * Set serviceProvider value
     * @param string $serviceProvider
     * @return \StructType\AuthCommit
     */
    public function setServiceProvider($serviceProvider = null)
    {
        // validation for constraint: string
        if (!is_null($serviceProvider) && !is_string($serviceProvider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceProvider, true), gettype($serviceProvider)), __LINE__);
        }
        $this->serviceProvider = $serviceProvider;
        return $this;
    }
    /**
     * Get returnCode value
     * @return string
     */
    public function getReturnCode()
    {
        return $this->returnCode;
    }
    /**
     * Set returnCode value
     * @param string $returnCode
     * @return \StructType\AuthCommit
     */
    public function setReturnCode($returnCode = null)
    {
        // validation for constraint: string
        if (!is_null($returnCode) && !is_string($returnCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnCode, true), gettype($returnCode)), __LINE__);
        }
        $this->returnCode = $returnCode;
        return $this;
    }
    /**
     * Get transactionID value
     * @return string
     */
    public function getTransactionID()
    {
        return $this->transactionID;
    }
    /**
     * Set transactionID value
     * @param string $transactionID
     * @return \StructType\AuthCommit
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->transactionID = $transactionID;
        return $this;
    }
    /**
     * Get authorizationCode value
     * @return string
     */
    public function getAuthorizationCode()
    {
        return $this->authorizationCode;
    }
    /**
     * Set authorizationCode value
     * @param string $authorizationCode
     * @return \StructType\AuthCommit
     */
    public function setAuthorizationCode($authorizationCode = null)
    {
        // validation for constraint: string
        if (!is_null($authorizationCode) && !is_string($authorizationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorizationCode, true), gettype($authorizationCode)), __LINE__);
        }
        $this->authorizationCode = $authorizationCode;
        return $this;
    }
    /**
     * Get cardTypeCode value
     * @return string
     */
    public function getCardTypeCode()
    {
        return $this->cardTypeCode;
    }
    /**
     * Set cardTypeCode value
     * @param string $cardTypeCode
     * @return \StructType\AuthCommit
     */
    public function setCardTypeCode($cardTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardTypeCode) && !is_string($cardTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardTypeCode, true), gettype($cardTypeCode)), __LINE__);
        }
        $this->cardTypeCode = $cardTypeCode;
        return $this;
    }
    /**
     * Get amount value
     * @return string
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param string $amount
     * @return \StructType\AuthCommit
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($amount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($amount, true)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get currency value
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\AuthCommit
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get cardNumber value
     * @return string
     */
    public function getCardNumber()
    {
        return $this->cardNumber;
    }
    /**
     * Set cardNumber value
     * @param string $cardNumber
     * @return \StructType\AuthCommit
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        $this->cardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\AuthCommit
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get receipt value
     * @return string|null
     */
    public function getReceipt()
    {
        return $this->receipt;
    }
    /**
     * Set receipt value
     * @param string $receipt
     * @return \StructType\AuthCommit
     */
    public function setReceipt($receipt = null)
    {
        // validation for constraint: string
        if (!is_null($receipt) && !is_string($receipt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receipt, true), gettype($receipt)), __LINE__);
        }
        $this->receipt = $receipt;
        return $this;
    }
    /**
     * Get receiptCardHolder value
     * @return string|null
     */
    public function getReceiptCardHolder()
    {
        return $this->receiptCardHolder;
    }
    /**
     * Set receiptCardHolder value
     * @param string $receiptCardHolder
     * @return \StructType\AuthCommit
     */
    public function setReceiptCardHolder($receiptCardHolder = null)
    {
        // validation for constraint: string
        if (!is_null($receiptCardHolder) && !is_string($receiptCardHolder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiptCardHolder, true), gettype($receiptCardHolder)), __LINE__);
        }
        $this->receiptCardHolder = $receiptCardHolder;
        return $this;
    }
    /**
     * Get emvTerminal value
     * @return string|null
     */
    public function getEmvTerminal()
    {
        return $this->emvTerminal;
    }
    /**
     * Set emvTerminal value
     * @param string $emvTerminal
     * @return \StructType\AuthCommit
     */
    public function setEmvTerminal($emvTerminal = null)
    {
        // validation for constraint: string
        if (!is_null($emvTerminal) && !is_string($emvTerminal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emvTerminal, true), gettype($emvTerminal)), __LINE__);
        }
        $this->emvTerminal = $emvTerminal;
        return $this;
    }
    /**
     * Get token value
     * @return string|null
     */
    public function getToken()
    {
        return $this->token;
    }
    /**
     * Set token value
     * @param string $token
     * @return \StructType\AuthCommit
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        $this->token = $token;
        return $this;
    }
    /**
     * Get tokenValidUntil value
     * @return string|null
     */
    public function getTokenValidUntil()
    {
        return $this->tokenValidUntil;
    }
    /**
     * Set tokenValidUntil value
     * @param string $tokenValidUntil
     * @return \StructType\AuthCommit
     */
    public function setTokenValidUntil($tokenValidUntil = null)
    {
        // validation for constraint: string
        if (!is_null($tokenValidUntil) && !is_string($tokenValidUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenValidUntil, true), gettype($tokenValidUntil)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($tokenValidUntil) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $tokenValidUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($tokenValidUntil, true)), __LINE__);
        }
        $this->tokenValidUntil = $tokenValidUntil;
        return $this;
    }
}
