<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArrivalSearch StructType
 * @subpackage Structs
 */
class ArrivalSearch extends AbstractStructBase
{
    /**
     * The arrival
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $arrival;
    /**
     * The lastnamefirstname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lastnamefirstname;
    /**
     * The orderer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $orderer;
    /**
     * The marketsegment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $marketsegment;
    /**
     * The arrived
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $arrived;
    /**
     * The resno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $resno;
    /**
     * The gdsresnumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $gdsresnumber;
    /**
     * Constructor method for ArrivalSearch
     * @uses ArrivalSearch::setArrival()
     * @uses ArrivalSearch::setLastnamefirstname()
     * @uses ArrivalSearch::setOrderer()
     * @uses ArrivalSearch::setMarketsegment()
     * @uses ArrivalSearch::setArrived()
     * @uses ArrivalSearch::setResno()
     * @uses ArrivalSearch::setGdsresnumber()
     * @param string $arrival
     * @param string $lastnamefirstname
     * @param string $orderer
     * @param string $marketsegment
     * @param string $arrived
     * @param string $resno
     * @param string $gdsresnumber
     */
    public function __construct($arrival = null, $lastnamefirstname = null, $orderer = null, $marketsegment = null, $arrived = null, $resno = null, $gdsresnumber = null)
    {
        $this
            ->setArrival($arrival)
            ->setLastnamefirstname($lastnamefirstname)
            ->setOrderer($orderer)
            ->setMarketsegment($marketsegment)
            ->setArrived($arrived)
            ->setResno($resno)
            ->setGdsresnumber($gdsresnumber);
    }
    /**
     * Get arrival value
     * @return string
     */
    public function getArrival()
    {
        return $this->arrival;
    }
    /**
     * Set arrival value
     * @param string $arrival
     * @return \StructType\ArrivalSearch
     */
    public function setArrival($arrival = null)
    {
        // validation for constraint: string
        if (!is_null($arrival) && !is_string($arrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrival, true), gettype($arrival)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($arrival) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $arrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($arrival, true)), __LINE__);
        }
        $this->arrival = $arrival;
        return $this;
    }
    /**
     * Get lastnamefirstname value
     * @return string|null
     */
    public function getLastnamefirstname()
    {
        return $this->lastnamefirstname;
    }
    /**
     * Set lastnamefirstname value
     * @param string $lastnamefirstname
     * @return \StructType\ArrivalSearch
     */
    public function setLastnamefirstname($lastnamefirstname = null)
    {
        // validation for constraint: string
        if (!is_null($lastnamefirstname) && !is_string($lastnamefirstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastnamefirstname, true), gettype($lastnamefirstname)), __LINE__);
        }
        $this->lastnamefirstname = $lastnamefirstname;
        return $this;
    }
    /**
     * Get orderer value
     * @return string|null
     */
    public function getOrderer()
    {
        return $this->orderer;
    }
    /**
     * Set orderer value
     * @param string $orderer
     * @return \StructType\ArrivalSearch
     */
    public function setOrderer($orderer = null)
    {
        // validation for constraint: string
        if (!is_null($orderer) && !is_string($orderer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderer, true), gettype($orderer)), __LINE__);
        }
        $this->orderer = $orderer;
        return $this;
    }
    /**
     * Get marketsegment value
     * @return string|null
     */
    public function getMarketsegment()
    {
        return $this->marketsegment;
    }
    /**
     * Set marketsegment value
     * @param string $marketsegment
     * @return \StructType\ArrivalSearch
     */
    public function setMarketsegment($marketsegment = null)
    {
        // validation for constraint: string
        if (!is_null($marketsegment) && !is_string($marketsegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketsegment, true), gettype($marketsegment)), __LINE__);
        }
        $this->marketsegment = $marketsegment;
        return $this;
    }
    /**
     * Get arrived value
     * @return string|null
     */
    public function getArrived()
    {
        return $this->arrived;
    }
    /**
     * Set arrived value
     * @param string $arrived
     * @return \StructType\ArrivalSearch
     */
    public function setArrived($arrived = null)
    {
        // validation for constraint: string
        if (!is_null($arrived) && !is_string($arrived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrived, true), gettype($arrived)), __LINE__);
        }
        $this->arrived = $arrived;
        return $this;
    }
    /**
     * Get resno value
     * @return string|null
     */
    public function getResno()
    {
        return $this->resno;
    }
    /**
     * Set resno value
     * @param string $resno
     * @return \StructType\ArrivalSearch
     */
    public function setResno($resno = null)
    {
        // validation for constraint: string
        if (!is_null($resno) && !is_string($resno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resno, true), gettype($resno)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($resno) && !preg_match('/([-+]){0,1}([0-9])*/', $resno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($resno, true)), __LINE__);
        }
        $this->resno = $resno;
        return $this;
    }
    /**
     * Get gdsresnumber value
     * @return string|null
     */
    public function getGdsresnumber()
    {
        return $this->gdsresnumber;
    }
    /**
     * Set gdsresnumber value
     * @param string $gdsresnumber
     * @return \StructType\ArrivalSearch
     */
    public function setGdsresnumber($gdsresnumber = null)
    {
        // validation for constraint: string
        if (!is_null($gdsresnumber) && !is_string($gdsresnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gdsresnumber, true), gettype($gdsresnumber)), __LINE__);
        }
        $this->gdsresnumber = $gdsresnumber;
        return $this;
    }
}
