<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Answer StructType
 * @subpackage Structs
 */
class Answer extends AbstractStructBase
{
    /**
     * The PAYMENT_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $PAYMENT_OBJID;
    /**
     * Constructor method for Answer
     * @uses Answer::setPAYMENT_OBJID()
     * @param string $pAYMENT_OBJID
     */
    public function __construct($pAYMENT_OBJID = null)
    {
        $this
            ->setPAYMENT_OBJID($pAYMENT_OBJID);
    }
    /**
     * Get PAYMENT_OBJID value
     * @return string
     */
    public function getPAYMENT_OBJID()
    {
        return $this->{'PAYMENT-OBJID'};
    }
    /**
     * Set PAYMENT_OBJID value
     * @param string $pAYMENT_OBJID
     * @return \StructType\Answer
     */
    public function setPAYMENT_OBJID($pAYMENT_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($pAYMENT_OBJID) && !is_string($pAYMENT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pAYMENT_OBJID, true), gettype($pAYMENT_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($pAYMENT_OBJID) && !preg_match('/([0-9])*/', $pAYMENT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($pAYMENT_OBJID, true)), __LINE__);
        }
        $this->PAYMENT_OBJID = $this->{'PAYMENT-OBJID'} = $pAYMENT_OBJID;
        return $this;
    }
}
