<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ALLOTMENTFORECASTENTRY StructType
 * @subpackage Structs
 */
class ALLOTMENTFORECASTENTRY extends AbstractStructBase
{
    /**
     * The date
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $date;
    /**
     * The roomcategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $roomcategory;
    /**
     * The noofroomsunused
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $noofroomsunused;
    /**
     * The netrevenueaccommodationunused
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $netrevenueaccommodationunused;
    /**
     * The foodunused
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $foodunused;
    /**
     * The othersunused
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $othersunused;
    /**
     * Constructor method for ALLOTMENTFORECASTENTRY
     * @uses ALLOTMENTFORECASTENTRY::setDate()
     * @uses ALLOTMENTFORECASTENTRY::setRoomcategory()
     * @uses ALLOTMENTFORECASTENTRY::setNoofroomsunused()
     * @uses ALLOTMENTFORECASTENTRY::setNetrevenueaccommodationunused()
     * @uses ALLOTMENTFORECASTENTRY::setFoodunused()
     * @uses ALLOTMENTFORECASTENTRY::setOthersunused()
     * @param string $date
     * @param string $roomcategory
     * @param string $noofroomsunused
     * @param string $netrevenueaccommodationunused
     * @param string $foodunused
     * @param string $othersunused
     */
    public function __construct($date = null, $roomcategory = null, $noofroomsunused = null, $netrevenueaccommodationunused = null, $foodunused = null, $othersunused = null)
    {
        $this
            ->setDate($date)
            ->setRoomcategory($roomcategory)
            ->setNoofroomsunused($noofroomsunused)
            ->setNetrevenueaccommodationunused($netrevenueaccommodationunused)
            ->setFoodunused($foodunused)
            ->setOthersunused($othersunused);
    }
    /**
     * Get date value
     * @return string
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\ALLOTMENTFORECASTENTRY
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($date) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($date, true)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get roomcategory value
     * @return string
     */
    public function getRoomcategory()
    {
        return $this->roomcategory;
    }
    /**
     * Set roomcategory value
     * @param string $roomcategory
     * @return \StructType\ALLOTMENTFORECASTENTRY
     */
    public function setRoomcategory($roomcategory = null)
    {
        // validation for constraint: string
        if (!is_null($roomcategory) && !is_string($roomcategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomcategory, true), gettype($roomcategory)), __LINE__);
        }
        $this->roomcategory = $roomcategory;
        return $this;
    }
    /**
     * Get noofroomsunused value
     * @return string
     */
    public function getNoofroomsunused()
    {
        return $this->noofroomsunused;
    }
    /**
     * Set noofroomsunused value
     * @param string $noofroomsunused
     * @return \StructType\ALLOTMENTFORECASTENTRY
     */
    public function setNoofroomsunused($noofroomsunused = null)
    {
        // validation for constraint: string
        if (!is_null($noofroomsunused) && !is_string($noofroomsunused)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noofroomsunused, true), gettype($noofroomsunused)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($noofroomsunused) && !preg_match('/([-+]){0,1}([0-9])*/', $noofroomsunused)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($noofroomsunused, true)), __LINE__);
        }
        $this->noofroomsunused = $noofroomsunused;
        return $this;
    }
    /**
     * Get netrevenueaccommodationunused value
     * @return string
     */
    public function getNetrevenueaccommodationunused()
    {
        return $this->netrevenueaccommodationunused;
    }
    /**
     * Set netrevenueaccommodationunused value
     * @param string $netrevenueaccommodationunused
     * @return \StructType\ALLOTMENTFORECASTENTRY
     */
    public function setNetrevenueaccommodationunused($netrevenueaccommodationunused = null)
    {
        // validation for constraint: string
        if (!is_null($netrevenueaccommodationunused) && !is_string($netrevenueaccommodationunused)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($netrevenueaccommodationunused, true), gettype($netrevenueaccommodationunused)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($netrevenueaccommodationunused) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $netrevenueaccommodationunused)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($netrevenueaccommodationunused, true)), __LINE__);
        }
        $this->netrevenueaccommodationunused = $netrevenueaccommodationunused;
        return $this;
    }
    /**
     * Get foodunused value
     * @return string
     */
    public function getFoodunused()
    {
        return $this->foodunused;
    }
    /**
     * Set foodunused value
     * @param string $foodunused
     * @return \StructType\ALLOTMENTFORECASTENTRY
     */
    public function setFoodunused($foodunused = null)
    {
        // validation for constraint: string
        if (!is_null($foodunused) && !is_string($foodunused)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($foodunused, true), gettype($foodunused)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($foodunused) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $foodunused)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($foodunused, true)), __LINE__);
        }
        $this->foodunused = $foodunused;
        return $this;
    }
    /**
     * Get othersunused value
     * @return string
     */
    public function getOthersunused()
    {
        return $this->othersunused;
    }
    /**
     * Set othersunused value
     * @param string $othersunused
     * @return \StructType\ALLOTMENTFORECASTENTRY
     */
    public function setOthersunused($othersunused = null)
    {
        // validation for constraint: string
        if (!is_null($othersunused) && !is_string($othersunused)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($othersunused, true), gettype($othersunused)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($othersunused) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $othersunused)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($othersunused, true)), __LINE__);
        }
        $this->othersunused = $othersunused;
        return $this;
    }
}
