<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ALLOTMENTDETAIL StructType
 * @subpackage Structs
 */
class ALLOTMENTDETAIL extends AbstractStructBase
{
    /**
     * The ALLOTMENTDETAIL_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ALLOTMENTDETAIL_OBJID;
    /**
     * The datefrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $datefrom;
    /**
     * The dateto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $dateto;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $category;
    /**
     * The noofrooms
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $noofrooms;
    /**
     * The washfactorabsolute
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $washfactorabsolute;
    /**
     * The openallotment
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $openallotment;
    /**
     * The releaseindays
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $releaseindays;
    /**
     * The releasetype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $releasetype;
    /**
     * The releaseuntil
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $releaseuntil;
    /**
     * The service
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $service;
    /**
     * The manualrate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $manualrate;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $rate;
    /**
     * The ACCOUNT
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ACCOUNT[]
     */
    public $ACCOUNT;
    /**
     * Constructor method for ALLOTMENTDETAIL
     * @uses ALLOTMENTDETAIL::setALLOTMENTDETAIL_OBJID()
     * @uses ALLOTMENTDETAIL::setDatefrom()
     * @uses ALLOTMENTDETAIL::setDateto()
     * @uses ALLOTMENTDETAIL::setCategory()
     * @uses ALLOTMENTDETAIL::setNoofrooms()
     * @uses ALLOTMENTDETAIL::setWashfactorabsolute()
     * @uses ALLOTMENTDETAIL::setOpenallotment()
     * @uses ALLOTMENTDETAIL::setReleaseindays()
     * @uses ALLOTMENTDETAIL::setReleasetype()
     * @uses ALLOTMENTDETAIL::setReleaseuntil()
     * @uses ALLOTMENTDETAIL::setService()
     * @uses ALLOTMENTDETAIL::setManualrate()
     * @uses ALLOTMENTDETAIL::setRate()
     * @uses ALLOTMENTDETAIL::setACCOUNT()
     * @param string $aLLOTMENTDETAIL_OBJID
     * @param string $datefrom
     * @param string $dateto
     * @param string $category
     * @param string $noofrooms
     * @param string $washfactorabsolute
     * @param string $openallotment
     * @param string $releaseindays
     * @param string $releasetype
     * @param string $releaseuntil
     * @param string $service
     * @param string $manualrate
     * @param string $rate
     * @param \StructType\ACCOUNT[] $aCCOUNT
     */
    public function __construct($aLLOTMENTDETAIL_OBJID = null, $datefrom = null, $dateto = null, $category = null, $noofrooms = null, $washfactorabsolute = null, $openallotment = null, $releaseindays = null, $releasetype = null, $releaseuntil = null, $service = null, $manualrate = null, $rate = null, array $aCCOUNT = array())
    {
        $this
            ->setALLOTMENTDETAIL_OBJID($aLLOTMENTDETAIL_OBJID)
            ->setDatefrom($datefrom)
            ->setDateto($dateto)
            ->setCategory($category)
            ->setNoofrooms($noofrooms)
            ->setWashfactorabsolute($washfactorabsolute)
            ->setOpenallotment($openallotment)
            ->setReleaseindays($releaseindays)
            ->setReleasetype($releasetype)
            ->setReleaseuntil($releaseuntil)
            ->setService($service)
            ->setManualrate($manualrate)
            ->setRate($rate)
            ->setACCOUNT($aCCOUNT);
    }
    /**
     * Get ALLOTMENTDETAIL_OBJID value
     * @return string
     */
    public function getALLOTMENTDETAIL_OBJID()
    {
        return $this->{'ALLOTMENTDETAIL-OBJID'};
    }
    /**
     * Set ALLOTMENTDETAIL_OBJID value
     * @param string $aLLOTMENTDETAIL_OBJID
     * @return \StructType\ALLOTMENTDETAIL
     */
    public function setALLOTMENTDETAIL_OBJID($aLLOTMENTDETAIL_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($aLLOTMENTDETAIL_OBJID) && !is_string($aLLOTMENTDETAIL_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aLLOTMENTDETAIL_OBJID, true), gettype($aLLOTMENTDETAIL_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($aLLOTMENTDETAIL_OBJID) && !preg_match('/([0-9])*/', $aLLOTMENTDETAIL_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($aLLOTMENTDETAIL_OBJID, true)), __LINE__);
        }
        $this->ALLOTMENTDETAIL_OBJID = $this->{'ALLOTMENTDETAIL-OBJID'} = $aLLOTMENTDETAIL_OBJID;
        return $this;
    }
    /**
     * Get datefrom value
     * @return string
     */
    public function getDatefrom()
    {
        return $this->datefrom;
    }
    /**
     * Set datefrom value
     * @param string $datefrom
     * @return \StructType\ALLOTMENTDETAIL
     */
    public function setDatefrom($datefrom = null)
    {
        // validation for constraint: string
        if (!is_null($datefrom) && !is_string($datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datefrom, true), gettype($datefrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($datefrom) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($datefrom, true)), __LINE__);
        }
        $this->datefrom = $datefrom;
        return $this;
    }
    /**
     * Get dateto value
     * @return string
     */
    public function getDateto()
    {
        return $this->dateto;
    }
    /**
     * Set dateto value
     * @param string $dateto
     * @return \StructType\ALLOTMENTDETAIL
     */
    public function setDateto($dateto = null)
    {
        // validation for constraint: string
        if (!is_null($dateto) && !is_string($dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateto, true), gettype($dateto)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($dateto) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($dateto, true)), __LINE__);
        }
        $this->dateto = $dateto;
        return $this;
    }
    /**
     * Get category value
     * @return string
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param string $category
     * @return \StructType\ALLOTMENTDETAIL
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($category) && mb_strlen($category) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($category)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($category) && mb_strlen($category) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($category)), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Get noofrooms value
     * @return string
     */
    public function getNoofrooms()
    {
        return $this->noofrooms;
    }
    /**
     * Set noofrooms value
     * @param string $noofrooms
     * @return \StructType\ALLOTMENTDETAIL
     */
    public function setNoofrooms($noofrooms = null)
    {
        // validation for constraint: string
        if (!is_null($noofrooms) && !is_string($noofrooms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noofrooms, true), gettype($noofrooms)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($noofrooms) && !preg_match('/([-+]){0,1}([0-9])*/', $noofrooms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($noofrooms, true)), __LINE__);
        }
        $this->noofrooms = $noofrooms;
        return $this;
    }
    /**
     * Get washfactorabsolute value
     * @return string
     */
    public function getWashfactorabsolute()
    {
        return $this->washfactorabsolute;
    }
    /**
     * Set washfactorabsolute value
     * @param string $washfactorabsolute
     * @return \StructType\ALLOTMENTDETAIL
     */
    public function setWashfactorabsolute($washfactorabsolute = null)
    {
        // validation for constraint: string
        if (!is_null($washfactorabsolute) && !is_string($washfactorabsolute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($washfactorabsolute, true), gettype($washfactorabsolute)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($washfactorabsolute) && !preg_match('/([-+]){0,1}([0-9])*/', $washfactorabsolute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($washfactorabsolute, true)), __LINE__);
        }
        $this->washfactorabsolute = $washfactorabsolute;
        return $this;
    }
    /**
     * Get openallotment value
     * @return string
     */
    public function getOpenallotment()
    {
        return $this->openallotment;
    }
    /**
     * Set openallotment value
     * @param string $openallotment
     * @return \StructType\ALLOTMENTDETAIL
     */
    public function setOpenallotment($openallotment = null)
    {
        // validation for constraint: string
        if (!is_null($openallotment) && !is_string($openallotment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($openallotment, true), gettype($openallotment)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($openallotment) && !preg_match('/([-+]){0,1}([0-9])*/', $openallotment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($openallotment, true)), __LINE__);
        }
        $this->openallotment = $openallotment;
        return $this;
    }
    /**
     * Get releaseindays value
     * @return string
     */
    public function getReleaseindays()
    {
        return $this->releaseindays;
    }
    /**
     * Set releaseindays value
     * @param string $releaseindays
     * @return \StructType\ALLOTMENTDETAIL
     */
    public function setReleaseindays($releaseindays = null)
    {
        // validation for constraint: string
        if (!is_null($releaseindays) && !is_string($releaseindays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($releaseindays, true), gettype($releaseindays)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($releaseindays) && !preg_match('/([-+]){0,1}([0-9])*/', $releaseindays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($releaseindays, true)), __LINE__);
        }
        $this->releaseindays = $releaseindays;
        return $this;
    }
    /**
     * Get releasetype value
     * @return string
     */
    public function getReleasetype()
    {
        return $this->releasetype;
    }
    /**
     * Set releasetype value
     * @param string $releasetype
     * @return \StructType\ALLOTMENTDETAIL
     */
    public function setReleasetype($releasetype = null)
    {
        // validation for constraint: string
        if (!is_null($releasetype) && !is_string($releasetype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($releasetype, true), gettype($releasetype)), __LINE__);
        }
        $this->releasetype = $releasetype;
        return $this;
    }
    /**
     * Get releaseuntil value
     * @return string
     */
    public function getReleaseuntil()
    {
        return $this->releaseuntil;
    }
    /**
     * Set releaseuntil value
     * @param string $releaseuntil
     * @return \StructType\ALLOTMENTDETAIL
     */
    public function setReleaseuntil($releaseuntil = null)
    {
        // validation for constraint: string
        if (!is_null($releaseuntil) && !is_string($releaseuntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($releaseuntil, true), gettype($releaseuntil)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($releaseuntil) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $releaseuntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($releaseuntil, true)), __LINE__);
        }
        $this->releaseuntil = $releaseuntil;
        return $this;
    }
    /**
     * Get service value
     * @return string
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param string $service
     * @return \StructType\ALLOTMENTDETAIL
     */
    public function setService($service = null)
    {
        // validation for constraint: string
        if (!is_null($service) && !is_string($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($service, true), gettype($service)), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Get manualrate value
     * @return string
     */
    public function getManualrate()
    {
        return $this->manualrate;
    }
    /**
     * Set manualrate value
     * @param string $manualrate
     * @return \StructType\ALLOTMENTDETAIL
     */
    public function setManualrate($manualrate = null)
    {
        // validation for constraint: string
        if (!is_null($manualrate) && !is_string($manualrate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manualrate, true), gettype($manualrate)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($manualrate) && !preg_match('/([-+]){0,1}([0-9])*/', $manualrate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($manualrate, true)), __LINE__);
        }
        $this->manualrate = $manualrate;
        return $this;
    }
    /**
     * Get rate value
     * @return string
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param string $rate
     * @return \StructType\ALLOTMENTDETAIL
     */
    public function setRate($rate = null)
    {
        // validation for constraint: string
        if (!is_null($rate) && !is_string($rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($rate) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($rate, true)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get ACCOUNT value
     * @return \StructType\ACCOUNT[]|null
     */
    public function getACCOUNT()
    {
        return $this->ACCOUNT;
    }
    /**
     * This method is responsible for validating the values passed to the setACCOUNT method
     * This method is willingly generated in order to preserve the one-line inline validation within the setACCOUNT method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateACCOUNTForArrayConstraintsFromSetACCOUNT(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $aLLOTMENTDETAILACCOUNTItem) {
            // validation for constraint: itemType
            if (!$aLLOTMENTDETAILACCOUNTItem instanceof \StructType\ACCOUNT) {
                $invalidValues[] = is_object($aLLOTMENTDETAILACCOUNTItem) ? get_class($aLLOTMENTDETAILACCOUNTItem) : sprintf('%s(%s)', gettype($aLLOTMENTDETAILACCOUNTItem), var_export($aLLOTMENTDETAILACCOUNTItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ACCOUNT property can only contain items of type \StructType\ACCOUNT, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ACCOUNT value
     * @throws \InvalidArgumentException
     * @param \StructType\ACCOUNT[] $aCCOUNT
     * @return \StructType\ALLOTMENTDETAIL
     */
    public function setACCOUNT(array $aCCOUNT = array())
    {
        // validation for constraint: array
        if ('' !== ($aCCOUNTArrayErrorMessage = self::validateACCOUNTForArrayConstraintsFromSetACCOUNT($aCCOUNT))) {
            throw new \InvalidArgumentException($aCCOUNTArrayErrorMessage, __LINE__);
        }
        $this->ACCOUNT = $aCCOUNT;
        return $this;
    }
    /**
     * Add item to ACCOUNT value
     * @throws \InvalidArgumentException
     * @param \StructType\ACCOUNT $item
     * @return \StructType\ALLOTMENTDETAIL
     */
    public function addToACCOUNT(\StructType\ACCOUNT $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ACCOUNT) {
            throw new \InvalidArgumentException(sprintf('The ACCOUNT property can only contain items of type \StructType\ACCOUNT, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ACCOUNT[] = $item;
        return $this;
    }
}
