<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AGREEMENT3 StructType
 * @subpackage Structs
 */
class AGREEMENT3 extends AbstractStructBase
{
    /**
     * The duedate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $duedate;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $amount;
    /**
     * Constructor method for AGREEMENT3
     * @uses AGREEMENT3::setDuedate()
     * @uses AGREEMENT3::setAmount()
     * @param string $duedate
     * @param string $amount
     */
    public function __construct($duedate = null, $amount = null)
    {
        $this
            ->setDuedate($duedate)
            ->setAmount($amount);
    }
    /**
     * Get duedate value
     * @return string
     */
    public function getDuedate()
    {
        return $this->duedate;
    }
    /**
     * Set duedate value
     * @param string $duedate
     * @return \StructType\AGREEMENT3
     */
    public function setDuedate($duedate = null)
    {
        // validation for constraint: string
        if (!is_null($duedate) && !is_string($duedate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duedate, true), gettype($duedate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($duedate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $duedate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($duedate, true)), __LINE__);
        }
        $this->duedate = $duedate;
        return $this;
    }
    /**
     * Get amount value
     * @return string
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param string $amount
     * @return \StructType\AGREEMENT3
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($amount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($amount, true)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
}
