<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for STOKENISATIONNOTIFICATIONV ServiceType
 * @subpackage Services
 */
class STOKENISATIONNOTIFICATIONV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_TOKENISATION_NOTIFICATION_V01
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service changes the flags of a credit card that is referenced by their object id.The object id is part of the notification message that is returned by the tokenisation interface.Except of the field "Flags" all fields
     * in CardModifyData are only set if the status of the notification message was successful.### Input- CARD-OBJID: Mandatory. Object ID of the credit card.- Flags: Mandatory. Flags to set for the credit card.- Token: The authorization code from the
     * notification message.- ExtAddRef: The Ext. additional reference from the notification message.- CCType: The type of the credit card (for example MasterCard or VISA).- ExpireDateHandle: The date when the card expires.- ExpireDate: The date until the
     * authorisation token is valid.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_TOKENISATION_NOTIFICATION_V01Request $body
     * @return \StructType\S_TOKENISATION_NOTIFICATION_V01Response|bool
     */
    public function S_TOKENISATION_NOTIFICATION_V01(\StructType\S_TOKENISATION_NOTIFICATION_V01Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_TOKENISATION_NOTIFICATION_V01($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named S_TOKENISATION_NOTIFICATION_V02
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service changes the flags of a credit card that is referenced by their object id.The object id is part of the notification message that is returned by the tokenisation interface.Except of the field "Flags" all fields
     * in CardModifyData are only set if the status of the notification message was successful.### Input- CARD-OBJID: Mandatory. Object ID of the credit card.- Flags: Mandatory. Flags to set for the credit card.- Token: The authorization code from the
     * notification message.- ExtAddRef: The Ext. additional reference from the notification message.- CCType: The type of the credit card (for example MasterCard or VISA).- ExpireDateHandle: The date when the card expires.- ExpireDate: The date until the
     * authorisation token is valid.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_TOKENISATION_NOTIFICATION_V02Request $body
     * @return \StructType\S_TOKENISATION_NOTIFICATION_V02Response|bool
     */
    public function S_TOKENISATION_NOTIFICATION_V02(\StructType\S_TOKENISATION_NOTIFICATION_V02Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_TOKENISATION_NOTIFICATION_V02($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_TOKENISATION_NOTIFICATION_V01Response|\StructType\S_TOKENISATION_NOTIFICATION_V02Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
