<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SSALESPOTENTIALGUESTCREATEV ServiceType
 * @subpackage Services
 */
class SSALESPOTENTIALGUESTCREATEV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_SALESPOTENTIAL_GUEST_CREATE_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service creates a new sales potential and a new guest that is going to be associated with the sales potential.### Input- GUEST-OBJID: (Mandatory) ObjID of the guest, which can be obtained from other defined services.
     * Mandatory- Sales potential data - status c - Newly Created a - Contact Attempted e - Contact Established p - Offer Preparation n - Negotiation - type m - mice l - logis - Guest data - firstname - lastname - phone1 - email1### Output-
     * SALESPOTENTIAL-OBJID: ObjID of the newly created sales potential
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_SALESPOTENTIAL_GUEST_CREATE_V001Request $body
     * @return \StructType\S_SALESPOTENTIAL_GUEST_CREATE_V001Response|bool
     */
    public function S_SALESPOTENTIAL_GUEST_CREATE_V001(\StructType\S_SALESPOTENTIAL_GUEST_CREATE_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_SALESPOTENTIAL_GUEST_CREATE_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_SALESPOTENTIAL_GUEST_CREATE_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
