<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SROOMSTATESEARCHV ServiceType
 * @subpackage Services
 */
class SROOMSTATESEARCHV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_ROOM_STATE_SEARCH_V002
     * Meta information extracted from the WSDL
     * - documentation: ### DeprecatedThis has been deprecated. Please refer to:- [S_ROOM_STATE_SEARCH_V003](../S_ROOM_STATE_SEARCH_V003) - Fixed incorrect naming (from guestType to personType)### GeneralThis service searches for room states. The result set
     * contains either a list of rooms or a specific room.In case no input criteria is given, a list of all configured rooms will be returned.### Input- room as room number: empty field results a list of rooms related to the other search criteria or all
     * rooms (see above)- category: room category; e.g. BD = Business Double- floor: floor the room is located- changesupplies: as housekeeping state defined in PMS; e.g. 04 - Room OK; 06 - Arrival Not Clean- maintenance: as technical state of the room,
     * e.g. 57 - heater faulty, All the parameters above beside room number are configurable and need to be requested from hotel in forehand### Output- room_number: number of the room- floor: location of the room, number of the floor as configured in SIHOT-
     * status: status of room, e.g. not occupied, checked in with guest name, blocked- room_category: category of the room, e.g. BS (business single)- housekeeping_state: sanitation state of the room, e.g. 06 = arrival not clean- technical_state: technical
     * state of the room, e.g. 99 = all ok
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_ROOM_STATE_SEARCH_V002Request $body
     * @return \StructType\S_ROOM_STATE_SEARCH_V002Response|bool
     */
    public function S_ROOM_STATE_SEARCH_V002(\StructType\S_ROOM_STATE_SEARCH_V002Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_ROOM_STATE_SEARCH_V002($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named S_ROOM_STATE_SEARCH_V003
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service searches for room states. The result set contains either a list of rooms or a specific room.In case no input criteria is given, a list of all configured rooms will be returned.### Input- room as room number:
     * empty field results a list of rooms related to the other search criteria or all rooms (see above)- category: room category; e.g. BD = Business Double- floor: floor the room is located- changesupplies: as housekeeping state defined in PMS; e.g. 04 -
     * Room OK; 06 - Arrival Not Clean- maintenance: as technical state of the room, e.g. 57 - heater faulty, All the parameters above beside room number are configurable and need to be requested from hotel in forehand### Output- room_number: number of the
     * room- floor: location of the room, number of the floor as configured in SIHOT- status: status of room, e.g. not occupied, checked in with guest name, blocked- room_category: category of the room, e.g. BS (business single)- housekeeping_state:
     * sanitation state of the room, e.g. 06 = arrival not clean- technical_state: technical state of the room, e.g. 99 = all ok
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_ROOM_STATE_SEARCH_V003Request $body
     * @return \StructType\S_ROOM_STATE_SEARCH_V003Response|bool
     */
    public function S_ROOM_STATE_SEARCH_V003(\StructType\S_ROOM_STATE_SEARCH_V003Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_ROOM_STATE_SEARCH_V003($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named S_ROOM_STATE_SEARCH_V01
     * Meta information extracted from the WSDL
     * - documentation: ### DeprecatedThis has been deprecated. Please refer to:- [S_ROOM_STATE_SEARCH_V002](../S_ROOM_STATE_SEARCH_V002)### GeneralThis service searches for room states. The result contains either a list of rooms or a specific room.In case
     * no input criteria is given, a list of all configured rooms will be returned.### Input- room as room number: empty field results a list of rooms related to the other search criteria or all rooms (see above)- category: room category; e.g. BD = Business
     * Double- floor: floor the room is located- changesupplies: as housekeeping state defined in PMS; e.g. 04 - Room OK; 06 - Arrival Not Clean- maintenance: as technical state of the room, e.g. 57 - heater faulty, All the parameters above beside room
     * number are configurable and need to be requested from hotel in forehand### Output- room_number: number of the room- floor: location of the room, number of the floor as configured in SIHOT- status: status of room, e.g. not occupied, checked in with
     * guest name, blocked- room_category: category of the room, e.g. BS (business single)- housekeeping_state: sanitation state of the room, e.g. 06 = arrival not clean- technical_state: technical state of the room, e.g. 99 = all ok
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_ROOM_STATE_SEARCH_V01Request $body
     * @return \StructType\S_ROOM_STATE_SEARCH_V01Response|bool
     */
    public function S_ROOM_STATE_SEARCH_V01(\StructType\S_ROOM_STATE_SEARCH_V01Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_ROOM_STATE_SEARCH_V01($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_ROOM_STATE_SEARCH_V002Response|\StructType\S_ROOM_STATE_SEARCH_V003Response|\StructType\S_ROOM_STATE_SEARCH_V01Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
