<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SROOMINGLISTROOMFORECASTGETV ServiceType
 * @subpackage Services
 */
class SROOMINGLISTROOMFORECASTGETV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * S_ROOMINGLIST_ROOM_FORECAST_GET_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service get the forcast values from a specific room.### Input- ROOMINGLIST-OBJID: ObjID of the room reservation, which can be obtained from defined services. Mandatory- used combo box:- category "19"- ratecategory
     * "PK"- rateSegment "PS"- personType "PG"
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_ROOMINGLIST_ROOM_FORECAST_GET_V001Request $body
     * @return \StructType\S_ROOMINGLIST_ROOM_FORECAST_GET_V001Response|bool
     */
    public function S_ROOMINGLIST_ROOM_FORECAST_GET_V001(\StructType\S_ROOMINGLIST_ROOM_FORECAST_GET_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_ROOMINGLIST_ROOM_FORECAST_GET_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_ROOMINGLIST_ROOM_FORECAST_GET_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
