<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SRESERVATIONSERVICEMANUALRATEFORCEMODIFYV ServiceType
 * @subpackage Services
 */
class SRESERVATIONSERVICEMANUALRATEFORCEMODIFYV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * S_RESERVATION_SERVICE_MANUAL_RATE_FORCE_MODIFY_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service forcefully modifies a service from a specific reservation, with the possibility of setting a manual rate. This means other factors like the reservation rates being frozen or not will be disregarded and the
     * modification carried out anyway.### Input- RESERVATION-OBJID: ObjID of the reservation, which can be obtained from other defined services. Mandatory- servicecode: service code, combo box key, which can be obtained from defined services. Mandatory-
     * datefrom: start date for the service. Mandatory- dateto: end date for the service. Mandatory- ratecategory: rate category, combo box key. Optional- pricesegment: price segment, combo box key. Optional- quantity: quantity. Optional- manualrate: price
     * per unit per day. Optional- discountgroup: discount group, combo box key. Optional- currency: currency, combo box key. Optional
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_RESERVATION_SERVICE_MANUAL_RATE_FORCE_MODIFY_V001Request $body
     * @return \StructType\S_RESERVATION_SERVICE_MANUAL_RATE_FORCE_MODIFY_V001Response|bool
     */
    public function S_RESERVATION_SERVICE_MANUAL_RATE_FORCE_MODIFY_V001(\StructType\S_RESERVATION_SERVICE_MANUAL_RATE_FORCE_MODIFY_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_RESERVATION_SERVICE_MANUAL_RATE_FORCE_MODIFY_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_RESERVATION_SERVICE_MANUAL_RATE_FORCE_MODIFY_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
