<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SREGISTRYSPEEDTESTV ServiceType
 * @subpackage Services
 */
class SREGISTRYSPEEDTESTV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_REGISTRY_SPEED_TEST_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service can be used to test access speeds to the SIHOT registry.### Input- Scenario: Test scenario to be executed. If left empty or not included, the standard test scenario is executed.### OutputTest result
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_REGISTRY_SPEED_TEST_V001Request $body
     * @return \StructType\S_REGISTRY_SPEED_TEST_V001Response|bool
     */
    public function S_REGISTRY_SPEED_TEST_V001(\StructType\S_REGISTRY_SPEED_TEST_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_REGISTRY_SPEED_TEST_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_REGISTRY_SPEED_TEST_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
