<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SRATESEARCHV ServiceType
 * @subpackage Services
 */
class SRATESEARCHV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_RATE_SEARCH_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service delivers the rate for a specific service for a specific period.### Input- from: service date from- to: service date to- serviceCode: service code for the service- rateCategory: rate category for the service-
     * rateSegment: (Optional) rate segment for the service- scope: (Optional) e.g: - "FORCECALCDAYPRICE" - price per day will be returned- discountGroup: (Optional) discount group for the service- currency: (Optional) currency to which you want to convert-
     * GUEST-OBJID: (Optional) guest specific price- ALLOTMENT-OBJID: (Optional) allotment specific price- List of person types (Optional) - guestType: (Optional) type of the guest - noOfPax: number of persons### Output- Rate you are looking for and
     * optional a list with the daily rates- Within each daily rate node, some occupancy data is also included. Please note that: - For sales categories, the occupancy percentage is not calculated so 0 will be the returned value - The number of occupied
     * rooms is a calculated figure between the total and available rooms. - Consequently, if the request is for a sales category with a defined maximum availability, it can be inaccurate.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_RATE_SEARCH_V001Request $body
     * @return \StructType\S_RATE_SEARCH_V001Response|bool
     */
    public function S_RATE_SEARCH_V001(\StructType\S_RATE_SEARCH_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_RATE_SEARCH_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_RATE_SEARCH_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
