<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SPOLICELISTADDV ServiceType
 * @subpackage Services
 */
class SPOLICELISTADDV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_POLICELIST_ADD_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service modifies a specific police-list entry.### Input- POLICELIST-OBJID: ObjID of the police-list entry, which can be obtained from defined services. Mandatory- All data to be modified
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_POLICELIST_ADD_V001Request $body
     * @return \StructType\S_POLICELIST_ADD_V001Response|bool
     */
    public function S_POLICELIST_ADD_V001(\StructType\S_POLICELIST_ADD_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_POLICELIST_ADD_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_POLICELIST_ADD_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
