<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SPERSONSERVICEADDV ServiceType
 * @subpackage Services
 */
class SPERSONSERVICEADDV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_PERSON_SERVICE_ADD_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service adds a service to a specific person.### Input- PERSON-OBJID: ObjID of the person, which can be obtained from defined services. Mandatory- servicecode: service code, combo box key, which can be obtained from
     * defined services. Mandatory- datefrom: start date for the service. Mandatory- dateto: end date for the service. Mandatory- ratecategory: rate category, combo box key. Optional- pricesegment: price segment, combo box key. Optional- quantity: quantity.
     * Optional- discountgroup: discount group, combo box key. Optional- currency: currency, combo box key. Optional
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_PERSON_SERVICE_ADD_V001Request $body
     * @return \StructType\S_PERSON_SERVICE_ADD_V001Response|bool
     */
    public function S_PERSON_SERVICE_ADD_V001(\StructType\S_PERSON_SERVICE_ADD_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_PERSON_SERVICE_ADD_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_PERSON_SERVICE_ADD_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
