<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SPAYMENTABORTV ServiceType
 * @subpackage Services
 */
class SPAYMENTABORTV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_PAYMENT_ABORT_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service aborts a failed payment that was created by an init payment request with the payment engine.### Input - cardInfoRefID. Mandatory. Object ID of the card info that was created during the inital payment request.-
     * returnCode. Mandatory. Return code of the payment engine. The value "0" (successful) is not allowed here.- returnText. Mandatory. Text describing the return code.- returnCodeSP. Optional. Return code of the service provider.- returnTextSP. Optional.
     * text describing the return code of the service provider.- serviceProvider. Mandatory. The service provider used for the payment.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_PAYMENT_ABORT_V001Request $body
     * @return \StructType\S_PAYMENT_ABORT_V001Response|bool
     */
    public function S_PAYMENT_ABORT_V001(\StructType\S_PAYMENT_ABORT_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_PAYMENT_ABORT_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_PAYMENT_ABORT_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
