<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SMOBILEROOMCLEANINGSTATUSCHANGEV ServiceType
 * @subpackage Services
 */
class SMOBILEROOMCLEANINGSTATUSCHANGEV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * S_MOBILE_ROOM_CLEANING_STATUS_CHANGE_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service changes the room status (cleaning status) of a given room.### Input - ROOM-OBJID: Mandatory. Object ID of the room, which can be obtained from defined services- Cleaning_Status: Mandatory. One of the
     * configured cleaning status for the hotel needs to be entered.- Standard cleaning status are: - 01 - Dirty - 02 - In Process - 03 - Inspection - 04 - Room OK - 05 - Additional Work - 06 - Arrival Not Clean
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_MOBILE_ROOM_CLEANING_STATUS_CHANGE_V001Request $body
     * @return \StructType\S_MOBILE_ROOM_CLEANING_STATUS_CHANGE_V001Response|bool
     */
    public function S_MOBILE_ROOM_CLEANING_STATUS_CHANGE_V001(\StructType\S_MOBILE_ROOM_CLEANING_STATUS_CHANGE_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_MOBILE_ROOM_CLEANING_STATUS_CHANGE_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_MOBILE_ROOM_CLEANING_STATUS_CHANGE_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
