<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SMOBILELOSTANDFOUNDSEARCHV ServiceType
 * @subpackage Services
 */
class SMOBILELOSTANDFOUNDSEARCHV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * S_MOBILE_LOST_AND_FOUND_SEARCH_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service searches for lost and found.### Input- dateFrom: date when found. Optional- dateTo: date when delivered. Optional- description: item. Optional- guest: client information. Optional- room: where was found.
     * Optional- location: where was found. Optional- type: Use the key from the comboxbox -> "FT". Optional- status: Use the key from the comboxbox -> "S1". Optional- deleted: removed. Optional- number: object number. Optional### OutputList of lost and
     * found matching the request.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_MOBILE_LOST_AND_FOUND_SEARCH_V001Request $body
     * @return \StructType\S_MOBILE_LOST_AND_FOUND_SEARCH_V001Response|bool
     */
    public function S_MOBILE_LOST_AND_FOUND_SEARCH_V001(\StructType\S_MOBILE_LOST_AND_FOUND_SEARCH_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_MOBILE_LOST_AND_FOUND_SEARCH_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_MOBILE_LOST_AND_FOUND_SEARCH_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
